/**
 * Created by Ahmed Barakat on 8/19/14.
 */

String.prototype.padRight = function (l, c) {
    return this + Array(l - this.length + 1).join(c || " ")
}
var screenWidth = window.screen.width;
if (screenWidth < 1366)
    $('html').css({zoom: (screenWidth * 100 / 1366) + '%' });

//mkilani- disable the browser zooming for chrome
//document.firstElementChild.style.zoom = "reset";

function LeftPad(str, max) {
    str = str.toString();
    return str.length < max ? LeftPad("0" + str, max) : str;
}

jQuery.fn.center = function () {

    var top = (($(window).height() - $(this).outerHeight()) / 2) +
        $(window).scrollTop();
    var left = (($(window).width() - $(this).outerWidth()) / 2) +
        $(window).scrollLeft();


    this.css("position", "absolute");
    this.css("top", Math.max(0, top) + "px");
    this.css("left", Math.max(0, left) + "px");
    return this;
}

function account_id(level, maxId, parentId) {
    level = level + 1;
    parentId = parentId.trim();
    if (maxId == '' || maxId == undefined) {

        return parentId + '01';
    }

    switch (level) {
        case 1:
            return maxId + 1;
            break;
        case 2:
            var id = parseInt(maxId.substr(1)) + 1;
            return parentId + LeftPad(id, 2);
            break;
        case 3:
            var id = parseInt(maxId.substr(3)) + 1;
            return parentId + LeftPad(id, 2);
            break;
        case 4:
            var id = parseInt(maxId.substr(5)) + 1;
            return parentId + LeftPad(id, 2);
            break;
        case 5:
            var id = parseInt(maxId.substr(7)) + 1;
            return parentId + LeftPad(id, 2);
            break;
        case 6:
            var id = parseInt(maxId.substr(9)) + 1;
            return parentId + LeftPad(id, 2);
            break;
    }
}

function account_withRoot_id(level, maxId, parentId) {
    level = level;
    parentId = parentId.trim();


    if (maxId == '' || maxId == undefined) {
        if (parentId == '0')
            return 1;//parentId+'01';
        else  return parentId + '01';
    }

    switch (level) {
        case 1:
            return parseInt(maxId) + 1;
            break;
        case 2:
            var id = parseInt(maxId.substr(1)) + 1;
            return parentId + LeftPad(id, 2);
            break;
        case 3:
            var id = parseInt(maxId.substr(3)) + 1;
            return parentId + LeftPad(id, 2);
            break;
        case 4:
            var id = parseInt(maxId.substr(5)) + 1;
            return parentId + LeftPad(id, 2);
            break;
        case 5:
            var id = parseInt(maxId.substr(7)) + 1;
            return parentId + LeftPad(id, 2);
            break;
        case 6:
            var id = parseInt(maxId.substr(9)) + 1;
            return parentId + LeftPad(id, 2);
            break;
    }
}
//---------------------
function class_id(level, maxId, parentId) {
    level = level + 1;
    parentId = parentId.trim();

    if (maxId == '' || maxId == undefined) {
        if (level == 5)
            return parentId + '001';
        else
            return parentId + '01';
    }
    maxId = '1' + maxId;

    return (parseInt(maxId) + 1).toString().substr(1);


}

//---------------------
function structure_id(maxId, parentId) {

    parentId = parentId.trim();
    if (maxId == '' || maxId == undefined) {

        return parentId + '01';
    }

    maxId = '1' + maxId;

    return (parseInt(maxId) + 1).toString().substr(1);
}

tab_click();

function tab_click() {
   $('input,select').on("keypress", function (e) {

        if (e.keyCode == 13) {
            var inps = $("input, select"); //add select too
            for (var x = 0; x < inps.length; x++) {
                if (inps[x] == this) {
                    while ((inps[x + 1]) != undefined && (inps[x]).name == (inps[x + 1]).name) {
                        x++;
                    }
                    if ((x + 1) < inps.length) $(inps[x + 1]).focus();
                }
            }
            e.preventDefault();
        }
    });

}

/*function Up_Down(){
 $('input').bind('keyup', 'up', function(e) {
 var inputName = $(this).attr('name');
 console.log('',e);
 var inps = $('input[name="'+inputName+'"]'); //add select too
 for (var x = inps.length; x > 0; x--) {
 if (inps[x] == this) {

 $(inps[x - 1]).focus();
 }
 }   e.preventDefault();
 });

 $('input').bind('keyup', 'down', function(e) {
 var inputName = $(this).attr('name');
 console.log('',e);
 var inps = $('input[name="'+inputName+'"]'); //add select too
 for (var x = 0; x <inps.length; x++) {
 if (inps[x] == this) {

 $(inps[x + 1]).focus();
 }
 }   e.preventDefault();
 });
 }*/

function showAlert(title, message, style) {

    /*  $('#msg_container,#msg_container_alt').html('<div class="alert alert-'+style+' fade in" role="alert" style="display:none;"> <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">×</span><span class="sr-only">Close</span></button><strong>'+title+'</strong> '+message+' </div>');
     $('#msg_container .alert,#msg_container_alt .alert').slideDown();
     setInterval(function(){ $('#msg_container .alert,#msg_container_alt .alert').slideUp();},3000);*/

    showNotifications(message, title, style);
}

function showNotifications(n, t, i) {
    toastr.options = {
        closeButton: !0,
        debug: !1,
        positionClass: "toast-top-right",
        onclick: null,
        showDuration: "600",
        hideDuration: "1000",
        timeOut: "6000",
        extendedTimeOut: "1000",
        showEasing: "swing",
        hideEasing: "linear",
        showMethod: "fadeIn",
        hideMethod: "fadeOut"
    };
    toastr[i](n, t);
}


function warning_msg(title, message) {
    showAlert(title, message, 'warning');
}


function success_msg(title, message) {
    showAlert(title, message, 'success');
}


function info_msg(title, message) {
    showAlert(title, message, 'info');
}


function danger_msg(title, message) {
    showAlert(title, message, 'error');
}

//mkilani- get format numbers like 999,999.99
function num_format(n) {
    return n.toFixed(2).replace(/./g, function (c, i, a) {
        return i > 0 && c !== "." && (a.length - i) % 3 === 0 ? "," + c : c;
    });
}

//mkilani- get the total and rate of table column
function totals(tb) {
    var total = 0;
    $('#' + tb + ' tbody .total').each(function () {
        total += +parseFloat($(this).text().replace(/,/g, ''));
    });
    $('#' + tb + ' tfoot .total').text(num_format(total));
    $('#' + tb + ' tfoot #h_total').val(total);

    var total2 = 0;
    $('#' + tb + ' tbody .total2').each(function () {
        total2 += +parseFloat($(this).text().replace(/,/g, ''));
    });
    $('#' + tb + ' tfoot .total2').text(num_format(total2));

    var rate = 0;
    $('#' + tb + ' tbody .rate').each(function () {
        if ($(this).val() != '')
            rate += +parseFloat($(this).val());
    });
    $('#' + tb + ' tfoot .rate').text(num_format(rate) + ' %');
}

//mkilani- get (count * price)  and  rate % and refresh the total
function refresh_total(tb) {
    $('#' + tb + ' .ccount').change(function () {
        $(this).closest('tr').children(".total").text(num_format($(this).val() * $(this).closest('tr').find(".price").val()));
        totals(tb);
    });

    $('#' + tb + ' .price').change(function () {
        $(this).closest('tr').children(".total").text(num_format($(this).val() * $(this).closest('tr').find(".ccount").val()));
        totals(tb);
    });

    $('#' + tb + ' .rate').change(function () {
        $(this).closest('tr').children(".total").text(num_format($(this).val() * $('#' + tb + ' #total_price').val() / 100));
        totals(tb);
    });
}

// mkilani- to click on something
function actuateLink(link) {
    var allowDefaultAction = true;

    if (link.click) {
        link.click();

        return;
    }
    else if (document.createEvent) {
        var e = document.createEvent('MouseEvents');
        e.initEvent(
            'click'     // event type
            , true      // can bubble?
            , true      // cancelable?
        );
        allowDefaultAction = link.dispatchEvent(e);
    }

    if (allowDefaultAction) {
        var f = document.createElement('form');
        f.action = link.href;
        document.body.appendChild(f);
        f.submit();
    }
}

// mkilani- send e-mail
function _send_mail(to, subject, send_text, html) {
    if (to == undefined) {
        warning_msg('تنبيه..', 'يجب تحديد البريد الالكتروني المرسل اليه');
        return false;
    }
    if (subject == undefined)
        subject = '';
    if (send_text == undefined)
        send_text = '';
    if (html == undefined)
        html = 0;

    var mail_url = _base_url + 'settings/mail/public_send';
    var values = {to: to, subject: subject, send_text: send_text, html: html};

    get_data(mail_url, values, function (ret) {
        if (ret == 1) {
            return 1;
        }
        else {
            warning_msg('تنبيه..', 'لم يتم ارسال البريد الالكتروني');
        }
    }, 'html');
}

//mkilani- restart search when back from browser
function auto_restart_search() {
    $('form input:text, form select').each(function () {
        if ($(this).val() != '') {
            search();
            info_msg('يرجى الانتظار', 'جار اعادة عرض السجلات السابقة');
            return false;
        }
    });
}

function delete_action() {
    $('a[data-action="delete"]').click(function () {
        $(this).closest('tr').remove();
        if (typeof update_after_delete == 'function') {
            update_after_delete();
        }
    });

}
//Function For Check All checkboxes
function initFunctions() {

    $('.table tbody tr').click(function () {

        $(this).parent().find('tr').removeClass('selected');
        $(this).addClass('selected');

    });

    $('.tb-row').click(function () {

        $(this).removeClass('selected');
        $(this).addClass('selected');

    });

    Apply_Sort();
    delete_action();

    $('input:checkbox').on('change', function () {


        var set = jQuery(this).attr("data-set");
        var checked = jQuery(this).is(":checked");
        jQuery(set).each(function () {
            if (checked) {

                $(this).prop("checked", true);
                $(this).attr("checked", true);
            } else {

                $(this).prop("checked", false);
                $(this).attr("checked", false);
            }
            $(this).parents('tr').toggleClass("active");
        });
    });
}
initFunctions();

function _showReport(url, full) {

    if (full == undefined || full == '')
        full = false;

    if ((url.indexOf('reports?report=') > -1 || url.indexOf('reports?type=') > -1) || (full == true)) {

        $('#report .modal-dialog').width(window.screen.width - 60);
        $('#report .modal-dialog').height('90%');

    }


    $('#report .modal-body').html('<iframe width="100%" height="100%" frameborder="0"   allowtransparency="true" src="' + url + '"></iframe>');
    $('#report').modal();
}

function get_to_link(url) {
    window.location.href = url;
}


$('i[class="icon icon-reply"]').closest('a').attr('onclick', "return confirm('هل تريد الرجوع للخلف ؟!');");

$('body').on("keyup", function (e) {
    /* ENTER PRESSED*/
    /* if (e.keyCode == 27) {

     if(!$('#report').hasClass('in'))
     window.history.back();
     else $('#report').modal('hide');

     }*/

});
$('#search-tbl').focus();
$('#search-tbl').keyup(function (e) {

    var DataSet = $('#' + $(this).attr('data-set'));

    var text = $(this).val();
    if (e.keyCode == 13 || text == '') {
        if ($(DataSet).prop('tagName') != 'UL') {
            $('tr > td.filterd', DataSet).removeClass('filterd');

            $('tr > td:contains("' + text + '")', DataSet).each(function () {
                $(this).addClass('filterd');
            });

            $('tr', DataSet).hide();
            $('thead >tr:first-child', DataSet).show();
            $('tr > td.filterd', DataSet).parents('tr').show();

        } else {

            $('.tb-row > li.filterd', DataSet).removeClass('filterd');

            $('.tb-row > li:contains("' + text + '")', DataSet).each(function () {
                $(this).addClass('filterd');
            });

            $('.tb-row', DataSet).hide();

            $('.tb-row > li.filterd', DataSet).parents('.tb-row').show();
        }
    }


});


apply_scroll();

function apply_scroll() {
    $(window).scroll(function () {

        var wintop = $(window).scrollTop(), docheight = $(document).height(), winheight = $(window).height();
        var scrolltrigger = 0.95;
        var winToS = (wintop / (docheight - winheight));

        if (screenWidth < 1366) {
            scrolltrigger = ((screenWidth * 100 / 1366) * scrolltrigger ) / 100;
            winToS = ((wintop / (docheight - winheight)) * 100) / (screenWidth * 100 / 1366);
        }


        if (winToS > scrolltrigger) {

            if (typeof LoadingData == 'function') {
                LoadingData();
            }
        }
    });

}

function replaceAll(find, replace, str) {
    str = str == undefined ? '' : str;
    return str.replace(new RegExp(find, 'g'), replace);
}

function isNaNVal(val, d) {
    if (d == undefined)
        d = 5;

    if (val == '' || isNaN(parseFloat(val)))
        return 0;
    else return parseFloat(parseFloat(val).toFixed(d));

}

function isNaNValMath(val, d) {
    if (d == undefined)
        d = 5;

    if (val == '' || isNaN(parseFloat(val)))
        return 0;
    //else return parseFloat(parseFloat(val).toFixed(d));
    else return Math.round((parseFloat(val).toFixed(d) * 1000) / 10) / 100;

}

function reload_Page() {
    setTimeout(function () {

        window.location.reload();

    }, 1000);
}

$('legend').click(function () {

    $(this).closest('fieldset').find('div.modal-body').toggle('slide');
    $(this).closest('fieldset').find('div.modal-footer').toggle('slide');
});

function VAL_TX_VALID(VAL, TX, VAT_TYPE, HAVE_TX) {

    var RES;
    if (HAVE_TX == 1 && VAT_TYPE == 1)

        RES = VAL - GET_TAX_VAL(VAL, TX, 1);
    else
        RES = VAL;

    return isNaNVal(RES, 2);
}

function GET_TAX_VAL(val, tx, vat_type) {
    var res;
    if (vat_type == 1)

        res = val - (val / (1 + (tx / 100)));

    else if (vat_type == 2)

        res = val * (tx / 100 );

    return res;
}


function GET_DISCOUNT(val, disc_val, disc_type) {

    var res = 0;

    if (disc_type == 1)

        res = disc_val;

    else if (disc_type == 2 && disc_val > 0)

        res = val * (disc_val / 100);

    else if (disc_val = 0)
        res = 0;

    return  res;
}

function GET_TAX_VAL_WT_DESC(val, val2, desc_num, tx) {
    var res;
    var total_tx;
    var desc_tx;
    var waste;
    var done_n;
    var not_done;
    var new_val;

    waste = val + val2;
    done_n = val / waste;
    not_done = val2 / waste;
    new_val = done_n * desc_num;
    total_tx = GET_TAX_VAL(val, tx, 2) - GET_TAX_VAL(new_val, tx, 2);

    res = total_tx;

    return  res;

}

(function () {

    var beforePrint = function () {
        console.log('Functionality to run before printing.');
    };

    var afterPrint = function () {
        console.log('Functionality to run after printing');
    };

    if (window.matchMedia) {
        var mediaQueryList = window.matchMedia('print');
        mediaQueryList.addListener(function (mql) {
            if (mql.matches) {
                beforePrint();
            } else {
                afterPrint();
            }
        });
    }

    window.onbeforeprint = beforePrint;
    window.onafterprint = afterPrint;

}());


$(".navbar-nav li").hover(function () {
        $(this).children("ul").stop().fadeIn("fast");
    },
    function () {
        $(this).children("ul").stop().fadeOut("fast");
    });

//Up_Down();
//Apply_Sort();

function Apply_Sort() {

    $('fieldset[data-allow-sort]').append('<input type="hidden" name="sort_data" />');

    $('th[data-sort]').each(function (i) {
        var dir = $(this).attr('data-sort-dir');
        if ($('i', $(this)).length <= 0)
            $(this).append('<i class=""></i>');
        if (dir == 'desc')
            $('i', $(this)).attr('class', 'icon icon-angle-up');
        else if (dir == 'asc')
            $('i', $(this)).attr('class', 'icon icon-angle-down');


        $(this).click(function () {

            $('i', $('th[data-sort]')).not($(this)).attr('class', '');

            var dir = $(this).attr('data-sort-dir');
            var sort_c = $(this).attr('data-sort');

            if (dir == 'desc') {
                $('i', $(this)).attr('class', 'icon icon-angle-down');
                $(this).attr('data-sort-dir', 'asc');
                sort_c = ' ' + sort_c + ' asc ';

            } else {
                $('i', $(this)).attr('class', 'icon icon-angle-up');
                $(this).attr('data-sort-dir', 'desc');
                sort_c = ' ' + sort_c + ' desc ';
            }

            $('input[name="sort_data"]').val(sort_c);


            search_data();

        });
    });
}

function add_row(a, empty, c, countInput) {

    var tabel = $(a).closest('table');
    var tr = $('tbody > tr:first', tabel).clone();
    var count = $('tbody tr', tabel).length + 1;

    $(empty, $(tr)).val('');
    $(empty, $(tr)).not('select').text('');
    $(empty, $(tr)).attr('value', '');
    $(empty, $(tr)).children().removeAttr('selected');

    $('input[type="checkbox"]', $(tr)).prop('checked', false);
    $('input[type="checkbox"]', $(tr)).attr('checked', false);


    $('tbody', tabel).append(tr);

    if (c)
        $('td:first', $(tr)).text(count);
    if (countInput != undefined) {
        $(countInput, $(tr)).val(count);
        $(countInput, $(tr)).attr('value', count);
    }

    tr.html(replaceAll('_0', '_' + (count - 1), tr.html()));

    $('input:regex(name,[0]),select:regex(name,[0].),textarea:regex(name,[0])', tr).each(function (i) {

        var name = $(this).attr('name');
        $(this).attr('name', name.replace('0', count - 1));

    });

    if (typeof reBind == 'function') {
        reBind();
    }

    if (typeof reBindAfterInsert == 'function') {
        reBindAfterInsert(tr);
    }

    $('td[data-action="delete"]', tr).html('<a data-action="delete" href="javascript:;"><i class="icon icon-trash delete-action"></i> </a> ');
    delete_action();
    reBindDateTime();
}


jQuery.expr[':'].regex = function (elem, index, match) {
    var matchParams = match[3].split(','),
        validLabels = /^(data|css):/,
        attr = {
            method: matchParams[0].match(validLabels) ?
                matchParams[0].split(':')[0] : 'attr',
            property: matchParams.shift().replace(validLabels, '')
        },
        regexFlags = 'ig',
        regex = new RegExp(matchParams.join('').replace(/^s+|s+$/g, ''), regexFlags);
    return regex.test(jQuery(elem)[attr.method](attr.property));
}

function reBindDateTime() {
    if ($.fn.datetimepicker) {
        $('input[data-type="date"]').datetimepicker({
            pickTime: false

        });
    }
}


function reloadIframeOfReport() {
    $('#report iframe').each(function () {
        this.contentWindow.location.reload(true);
    });
}

function Up_Down() {
    $("input").bind("keyup", "up", function (n) {

        for (var r = $(this).attr("name").replace(/\w+\[[\d]]+/g, ""), i = $('input[name="' + r + '"]'), t = i.length; t > 0; t--) i[t] == this && $(i[t - 1]).focus();
        n.preventDefault()
    }), $("input").bind("keyup", "down", function (n) {
        for (var r = $(this).attr("name").replace(/\w+\[[\d]]+/g, ""), i = $('input[name="' + r + '"]'), t = 0; t < i.length; t++) i[t] == this && $(i[t + 1]).focus();
        n.preventDefault()
    })
}

function Up_downTable() {

    $(document).bind("keyup", "up", function (n) {

        var prevTr = $('.table.selected-red tbody tr.selected').prev();

        if (prevTr != undefined) {
            $('.table.selected-red  tbody tr.selected').removeClass('selected');
            prevTr.addClass('selected');
        }
        n.stopPropagation()
        n.preventDefault()
    }), $(document).bind("keyup", "down", function (n) {

        var nextTr = $('.table.selected-red tbody tr.selected').next();
        if (nextTr != undefined) {
            $('.table.selected-red  tbody tr.selected').removeClass('selected');
            nextTr.addClass('selected');
        }
        n.stopPropagation()
        n.preventDefault()
    })
}

//Up_downTable();
//Up_Down();

$('button[data-hints]').click(function () {

    $('#hints-content').text($(this).attr('data-hints'));
    $('#hints-model').modal();
});

function restInputs(tr) {

    var tabel = $(tr).closest('table');

    console.log('', $('tbody tr', tabel).length);

    if ($('tbody tr', tabel).length <= 1) {

        $('input,select,textarea', $(tr)).val('');
        $('input,select,textarea', $(tr)).attr('value', '');
        $('input,textarea', $(tr)).text('');

        $('select option', $(tr)).prop('selected', false);
    } else {

        $(tr).remove();

    }

}
function GetTableRows(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";	
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='اختيار'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowsTechnical(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";	
	output += "<a href='javascript:getTeamTechnicalByIssu("+ID+");' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='اختيار'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowsKey (requiredFields,element,pk)
{
    output = "<tr>";
    ID = -1;
    for (var key in element) {
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
            }
            output += "<td>";
            output+=element[key];
            output += "</td>";
        }
    };
    output += "<td>";
    output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='اختيار'><i data-text='"+ID+"' class='flaticon2-chat-2' data-pk='"+pk+"'></i></a>";
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}
function GetTableRowsKeyT (requiredFields,element,pk,te)
{
    output = "<tr>";
    ID = -1;
    for (var key in element) {
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
            }
            output += "<td>";
            output+=element[key];
            output += "</td>";
        }
    };
    output += "<td>";
    output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='اختيار'><i data-text='"+te+"' class='flaticon2-chat-2' data-pk='"+pk+"'></i></a>";
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}
function GetTableRowsWithCheckBox(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
                output += "<td>";
                output += "<input type='checkbox' name='SubCheck[]' id='SubCheck' class='form-control' value='"+ID+"' />";
                output += "</td>";
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";	
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='اختيار'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";				
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowAdoptEmp(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";	
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md'><i class='fa fa-editEmps EmpAdopts' data-pk='"+ID+"'>اعتماد الموظف</i></a>";				
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowAdoptManager(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";	
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md'><i class='fa fa-editMag MangAdopts' data-pk='"+ID+"'>اعتماد المدير</i></a>";
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md'><i class='fa fa-trash-oEmp RetEmp' data-pk='"+ID+"'>ارجاع الموظف</i></a>";
	output += "معتمدة من الموظف"				
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowAdoptManReturn(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";	
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md'><i class='fa fa-ediMant RetMang' data-pk='"+ID+"'>ارجاع المدير</i></a>";	
	output += "معتمدة من المدير"			
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowAdoptTaft(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";
						
		}
	};				
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowView(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	SE = 0 ;
	DF = 0 ;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			if(key == 1){
			   SE = element[key];
			}
			if(key == 2){
			   DF = element[key];
			}
			
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";	
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='اختيار'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='عرض الدفعات'><i class='fa fa-trash-o kt-menu__link-icon la la-commenting' data-pk='"+SE+"'></i></a>";
	output += "<a href='javascript:DeletePaidSearch("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='حذف'><i class='fa fa-trash-deleteT kt-nav__link-icon flaticon2-trash' data-pk='"+DF+"'></i></a>";				
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowLast(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	SE = 0 ;
	Esd = 0 ;
	DF = 0 ;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			if(key == 1){
			   DF = element[key];
			}
			if(key == 7){
			   SE = element[key];
			}
			if(key == 8){
			   Esd = element[key];
			}

            output += "<td>";
            output+=element[key];
            output += "</td>";

		}
	};
	var Request_app_serial = $("#TXT_REQUEST_HIDDEN").val();
	output += "<td>";
	if(SE != 0){
		output += "<a href='javascript:SubscriberActual("+SE+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='مالك الإشتراك'><i class='flaticon2-chat-2' data-pk='"+SE+"'></i></a>";
	}else if(Esd != 0){
		output += "<a href='javascript:SubscriberActual("+Esd+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='مالك الإشتراك'><i class='flaticon2-chat-2' data-pk='"+Esd+"'></i></a>";
	}else{
		output += "<a href='javascript:SubscriberActual("+SE+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='مالك الإشتراك'><i class='flaticon2-chat-2' data-pk='"+SE+"'></i></a>";
	}
	output += "<a href='javascript:SubscriberBenifit("+Request_app_serial+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md purple' title='منتفع'><i class='kt-menu__link-icon la la-user' data-pk='"+DF+"'></i></a>";
          output += "<a href='javascript:showBills("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md green' title='عرض الفواتير'><i class='kt-menu__link-icon la la-commenting' data-pk='"+DF+"'></i></a>";
	output += "<a href='javascript:AddNotes("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='ملاحظات'><i class='kt-menu__link-icon la la-commenting' data-pk='"+DF+"'></i></a>";

	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowsKeyT (requiredFields,element,pk,te)
{
    output = "<tr>";
    ID = -1;
    for (var key in element) {
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
            }
            output += "<td>";
            output+=element[key];
            output += "</td>";
        }
    };
    output += "<td>";
    output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='اختيار'><i data-text='"+te+"' class='flaticon2-chat-2' data-pk='"+pk+"'></i></a>";
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}
function GetTableRowLast2(requiredFields,element)
{
    output = "<tr>";
    ID = -1;
    SE = 0 ;
    Esd = 0 ;
    DF = 0 ;
	typ = 0 ;
	radyat = 0 ;
	totals = 0 ;
    for (var key in element) {
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
            }
            if(key == 1){
                DF = element[key];
            }
            if(key == 7){
                SE = element[key];
            }
            if(key == 8){
                Esd = element[key];
            }
            //Mtaqia
            if(key == 10){
                typ = element[key];
            }
			
			if(key == 11){
                radyat = element[key];
            }

            if(key != 10){
                output += "<td>";
                output+=element[key];
                output += "</td>";
            }
        }
    };
	var Request_app_serial = $("#TXT_REQUEST_HIDDEN").val();	
	if(SE != 0){
        output += "<a href='javascript:SubscriberActual("+SE+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='مالك الاشتراك'><i class='flaticon2-chat-2' data-pk='"+SE+"' data-fk='"+radyat+"'></i></a>";
    }else if(Esd != 0){
        output += "<a href='javascript:SubscriberActual("+Esd+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='مالك الاشتراك'><i class='flaticon2-chat-2' data-pk='"+Esd+"'></i></a>";
    }else if(radyat != 0){
        output += "<a href='javascript:SubscriberActual("+radyat+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='مالك الاشتراك'><i class='flaticon2-chat-2' data-pk='"+radyat+"'></i></a>";
    }else{
        output += "<a href='javascript:SubscriberActual("+SE+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='مالك الاشتراك'><i class='flaticon2-chat-2' data-pk='"+SE+"'></i></a>";
    }
    output += "<a href='javascript:SubscriberBenifit("+Request_app_serial+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md purple' title='منتفع'><i class='kt-menu__link-icon la la-user' data-pk='"+DF+"'></i></a>";
    if(typ < 200){
        output += "<a href='javascript:showBills("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md green' title='عرض الفواتير'><i class='kt-nav__link-icon flaticon2-contract' data-pk='"+DF+"'></i></a>";
    }
	// Mtaqia
    if(typ >= 200 && typ < 300){
		
        output += "<a href='javascript:ShowPrPaidCharge("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md green' title='عرض شحنات مسبق الدفع'><i class='kt-nav__link-icon flaticon2-contract' data-pk='"+DF+"'></i></a>";
    }
    output += "<a href='javascript:AddNotes("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md blue' title='ملاحظات'><i class='kt-menu__link-icon la la-commenting' data-pk='"+DF+"'></i></a>";
    output += "<a href='javascript:DeleteSearchRising("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='حذف'><i class='fa fa-trash-delete kt-nav__link-icon flaticon2-trash' data-pk='"+DF+"'></i></a>";
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}
function GetTableRowLast3(requiredFields,element)
{
    output = "<tr>";
    ID = -1;
    SE = 0 ;
    Esd = 0 ;
    DF = 0 ;
	typ = 0 ;
	radyat = 0 ;
	totals = 0 ;
    for (var key in element) {
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
            }
            if(key == 1){
                DF = element[key];
            }
            if(key == 7){
                SE = element[key];
            }
            if(key == 8){
                Esd = element[key];
            }
            //Mtaqia
            if(key == 10){
                typ = element[key];
            }
			
			if(key == 11){
                radyat = element[key];
            }

            if(key != 10){
                output += "<td>";
                output+=element[key];
                output += "</td>";
            }
        }
    };
	var Request_app_serial = $("#TXT_REQUEST_HIDDEN").val();
    output += "<td>";
    if(typ >= 200 && typ <= 299){
		totals = ( parseFloat(radyat) + parseFloat(SE) ) ;
		output += "<a href='javascript:SubscriberActual("+totals+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='مالك الاشتراك'><i class='flaticon2-chat-2' data-pk='"+totals+"'></i></a>";
		output += "<a href='javascript:ShowPrPaidCharge("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md green' title='عرض شحنات مسبق الدفع'><i class='kt-nav__link-icon flaticon2-contract' data-pk='"+DF+"'></i></a>";
	}else{
		output += "<a href='javascript:SubscriberActual("+Esd+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='مالك الاشتراك'><i class='flaticon2-chat-2' data-pk='"+Esd+"'></i></a>";
		output += "<a href='javascript:showBills("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md green' title='عرض الفواتير'><i class='kt-menu__link-icon la la-commenting' data-pk='"+DF+"'></i></a>";
	}
	output += "<a href='javascript:SubscriberBenifit("+Request_app_serial+" , "+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md purple' title='منتفع'><i class='kt-menu__link-icon la la-user' data-pk='"+DF+"'></i></a>";
    output += "<a href='javascript:AddNotes("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md blue' title='ملاحظات'><i class='kt-nav__link-icon flaticon2-contract' data-pk='"+DF+"'></i></a>";
    output += "<a href='javascript:DeleteSearchRising("+DF+");' class='btn btn-sm btn-clean btn-icon btn-icon-md red' title='حذف'><i class='fa fa-trash-delete kt-nav__link-icon flaticon2-trash' data-pk='"+DF+"'></i></a>";
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}
function GetTableRow(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "</tr>";
	ID = -1;
	return output;
}

function GetTableRowProcess(requiredFields,element)
{
    output = "<tr>";
    ID = -1;
    PN = 0;
    for (var key in element) {
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
            }
            if(key == 0){
                PN = element[key];
            }
            output += "<td>";
            output+=element[key];
            output += "</td>";
        }
    };
    output += "<td>";
    output += "<a href='javascript:print_report("+PN+");' class='btn btn-sm btn-clean btn-icon btn-icon-md green'><i class='fa fa-print'> طباعة</i></a>";
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}

function GetTableRowsCheck(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='حفظ'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowsCheck1(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
				output += "<td>";
                output += "<input type='checkbox' name='check_data[]' class='checkboxes' value="+ID+">";
                output += "</td>";
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";
	output += "<a href='javascript:;' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='حفظ'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableR(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowsCheckAll(requiredFields,element)
{
    output = "<tr>";

    ID = -1;
    for (var key in element) {
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
                output += "<td>";
                output += "<input type='checkbox' name='check_data[]' class='checkboxes' value="+ID+"/>";
                output += "</td>";
            }
            output += "<td>";
            output+=element[key];
            output += "</td>";
        }
    };
    output += "<td>";
   /* output += "<a href='javascript:;' class='btn default btn-xs purple'><i class='fa fa-edit' data-pk='"+ID+"'>اختيار</i></a>";*/
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}
function GetTableRowHead(requiredFields,element)
{
	output = '';
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<th>";
			output+=element[key];
			output += "</th>";			
		}
	};				
	ID = -1;
	return output;
}
function GetTableRowViewProcess(requiredFields,element)
{
    output = "<tr>";
    ID = -1;
    SE = 0 ;
    DF = 0 ;
    process_case = 0 ;
    for (var key in element) {
        var len = element.length-1;
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
            }
            if(key == 1){
                SE = element[key];
            }
            if(key == 2){
                DF = element[key];
            }
            if(key < len){
                output += "<td>";
                output+=element[key];
                output += "</td>";
            }else{
                process_case = element[key];
            }

        }
    };
	var Request_app_serial = $("#TXT_REQUEST_HIDDEN").val();
    output += "<td>";
    output += "<a href='javascript:SelectProcessForElement("+ID+");' class='btn btn-sm btn-clean btn-icon btn-icon-md purple' title='اختيار'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
    
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}
function GetTableRowViewProcess1(requiredFields,element)
{
    output = "<tr>";
    ID = -1;
    SE = 0 ;
    DF = 0 ;
    process_case = 0 ;
    for (var key in element) {
        var len = element.length-1;
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
            }
            if(key == 1){
                SE = element[key];
            }
            if(key == 2){
                DF = element[key];
            }
            if(key < len){
                output += "<td>";
                output+=element[key];
                output += "</td>";
            }else{
                process_case = element[key];
            }

        }
    };
	var Request_app_serial = $("#TXT_REQUEST_HIDDEN").val();
    output += "<td>";
    output += "<a href='javascript:;' class='btn default btn-xs green' title='عرض الدفعات'><i class='fa fa-trash-o kt-nav__link-icon flaticon2-contract' data-pk='"+SE+"'></i></a>";
    output += "<a href='javascript:PaidModals("+ID+" , "+Request_app_serial+");' class='btn default btn-xs yellow' title='الدفعات'><i class='fa fa-add-o kt-menu__link-icon la la-commenting' data-pk='"+SE+"'></i></a>";
    output += "<a href='javascript:DeletePaidSearch("+DF+");' class='btn default btn-xs red' title='حذف'><i class='fa fa-trash-deleteT kt-nav__link-icon flaticon2-trash' data-pk='"+DF+"'></i></a>";
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}
function GetTableRowsWithCheckBoxHidden(requiredFields,element)
{
    output = "<tr>";
    ID = -1;
    newKey = 1;
    for (var key in element) {
        if ($.inArray(key,requiredFields)){
            if (ID == -1){
                ID = element[key];
                output += "<td>";
                output += "<input type='checkbox' name='SubCheck[]' id='SubCheck' class='form-control' value='"+ID+"' />";
                output += "</td>";
            }
            newKey = parseInt(key)+1;
            if(newKey < element.length){
            output += "<td>";
            output+=element[newKey];
            output += "</td>";
            }
        }
    };
    output += "<td>";
    output += "";
    output += "</td>";
    output += "</tr>";
    ID = -1;
    return output;
}
function GetTableRowAdoptTaft1(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	DF = 0;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			if(key == 1){
			   DF = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";
						
		}
	};
	var Request_app_serial = $("#TXT_REQUEST_HIDDEN").val();	
	output += "<td>";	
	 output += "<a href='javascript:PaidModals("+ID+" , "+Request_app_serial+");' class='btn btn-sm btn-clean btn-icon btn-icon-md' title='الدفعات'><i class='fa fa-add-o kt-menu__link-icon la la-commenting' data-pk='"+ID+"'></i></a>";				
	output += "</td>";			
	output += "</tr>";
	ID = -1;
	return output;
}

function GetTableRowsCheck2(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};
	output += "<td>";
	output += "<a href=\"javascript:get_project_one('"+ID+"');\" class='btn btn-sm btn-clean btn-icon btn-icon-md' title='حفظ'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowsCheck3(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";
	output += "<a href=\"javascript:get_project_two('"+ID+"');\" class='btn btn-sm btn-clean btn-icon btn-icon-md' title='حفظ'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowsCheck4(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";
	output += "<a href=\"javascript:get_project_three('"+ID+"');\" class='btn btn-sm btn-clean btn-icon btn-icon-md' title='حفظ'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
function GetTableRowsCheckISRequests(requiredFields,element)
{
	output = "<tr>";
	ID = -1;
	for (var key in element) {
		if ($.inArray(key,requiredFields)){
			if (ID == -1){
				ID = element[key];
			}
			output += "<td>";
			output+=element[key];
			output += "</td>";			
		}
	};				
	output += "<td>";
	output += "<a href=\"javascript:close_rquest('"+ID+"');\" class='btn btn-sm btn-clean btn-icon btn-icon-md' title='إلغاء الطلب'><i class='flaticon2-trash' data-pk='"+ID+"'></i></a>";
	output += "<a href=\"javascript:complete_rquest('"+ID+"');\" class='btn btn-sm btn-clean btn-icon btn-icon-md' title='استكمال الطلب'><i class='flaticon2-chat-2' data-pk='"+ID+"'></i></a>";
	output += "<a href=\"javascript:note_action_rquest('"+ID+"');\" class='btn btn-sm btn-clean btn-icon btn-icon-md' title='ملاحظات الطلب'><i class='flaticon2-chat-1' data-pk='"+ID+"'></i></a>";
	output += "</td>";
	output += "</tr>";
	ID = -1;
	return output;
}
/* mtaqia
* Remove Space before and after, then and % mark between every word.
* */
function add_percent_sign(str) {
    str_ = str.trim();
    return '%'+str_.split(' ').join('%')+'%';
}
/* ********************* */


/* Validation Input  */
$(".valid_name").change(function(){
    $(this).parent().parent().attr("class","");
    $("#help-block").html("");
    NoFind = $(this).val().length;
    if(NoFind <=2){
       $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-exclamation-sign");	   
       $(this).parent().parent().attr("class","has-error");
       $(this).next($("#help-block-name")).html("يجب أن يكون النص المدخل أكثر من حرفين");
    }else if(NoFind > 2 && NoFind < 4){
       $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-warning-sign");
       $(this).parent().parent().attr("class","has-warning");
       $(this).next($("#help-block-name")).html("");
    }else{
       $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-ok");
       $(this).parent().parent().attr("class","has-success");
       $(this).next($("#help-block-name")).html("");
    }
});
//
$(".valid_text").change(function(){
    $(this).parent().parent().attr("class","");
    $("#help-block-note").html("");
    NoFind = $(this).val().length;
    if(NoFind <=5){
       $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-exclamation-sign");	   
       $(this).parent().parent().attr("class","has-error");
       $(this).next($("#help-block-note")).html(" يجب أن يكون النص المدخل أكثر من 5 حروف");
    }else if(NoFind > 5 && NoFind < 10){
       $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-warning-sign");
       $(this).parent().parent().attr("class","has-warning");
       $(this).next($("#help-block-note")).html("");
    }else{
       $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-ok");
       $(this).parent().parent().attr("class","has-success");
       $(this).next($("#help-block-note")).html("");
    }
});
//
$(".valid_text_large").change(function(){
    $(this).parent().parent().attr("class","");
    $("#help-block-note").html("");
    NoFind = $(this).val().length;
    if(NoFind > 50){
       $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-exclamation-sign");	   
       $(this).parent().parent().attr("class","has-error");
       $(this).next($("#help-block-note")).html(" يجب أن يكون النص المدخل أقل من 50 حرف");
	   $("#btn_add_Address_requests").css('display','none');
    }else{
       $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-ok");
       $(this).parent().parent().attr("class","has-success");
       $(this).next($("#help-block-note")).html("");
	   $("#btn_add_Address_requests").css('display','block');
    }
});
//
$(".valid_email").change(function(){
    $(this).parent().parent().attr("class","");
    $("#help-block-email").html("");
    NoFind = $(this).val();
    filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	if(filter.test(NoFind)) {
	   $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-ok");
       $(this).parent().parent().attr("class","has-success");
       $(this).next($("#help-block-email")).html("");
	}else{
	   $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-exclamation-sign");	   
       $(this).parent().parent().attr("class","has-error");
       $(this).next($("#help-block-email")).html("نص الايميل المدخل غير صحيح");
	}
});
//
$(".valid_number").change(function(){
    $(this).parent().parent().attr("class","");
    $("#help-block-number").html("");
    NoFind = $(this).val();
    filter = /^[0-9.]+$/;
	if(filter.test(NoFind)) {
	   $(this).parent().parent().attr("class","");
	   $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-ok");
       $(this).parent().parent().attr("class","has-success");
       $(this).next($("#help-block-number")).html("");
	}else{
	   $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-exclamation-sign");	   
       $(this).parent().parent().attr("class","has-error");
       $(this).next($("#help-block-number")).html("يجب أن يحتوي التص المدخل على أرقام فقط");
	}
});
//
$(".valid_jawwal").change(function(){
    $(this).parent().parent().attr("class","");
    $("#help-block-number").html("");
    NoFind = $(this).val();
    filter = /^[0-9.]+$/;
	if(filter.test(NoFind)) {
		if(NoFind.length ==10){
		   $(this).parent().parent().attr("class","");
		   $(this).parent().attr("class","input-icon right");
		   $(this).parent().children("#icon-exclamation-sign").attr("class","icon-ok");
		   $(this).parent().parent().attr("class","has-success");
		   $(this).next($("#help-block-jawwal")).html("");
		}else{
			$(this).parent().attr("class","input-icon right");
       		$(this).parent().children("#icon-exclamation-sign").attr("class","icon-exclamation-sign");	   
       		$(this).parent().parent().attr("class","has-error");
      	    $(this).next($("#help-block-jawwal")).html("يجب أن يكون رقم الجوال مكون من 10 أرقام");
		}
	}else{
	   $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-exclamation-sign");	   
       $(this).parent().parent().attr("class","has-error");
       $(this).next($("#help-block-jawwal")).html("يجب أن يحتوي التص المدخل على أرقام فقط");
	}
});
//
$(".valid_phone").change(function(){
    $(this).parent().parent().attr("class","");
    $("#help-block-number").html("");
    NoFind = $(this).val();
    filter = /^[0-9.]+$/;
	if(filter.test(NoFind)) {
		if(NoFind.length ==9){
		   $(this).parent().parent().attr("class","");
		   $(this).parent().attr("class","input-icon right");
		   $(this).parent().children("#icon-exclamation-sign").attr("class","icon-ok");
		   $(this).parent().parent().attr("class","has-success");
		   $(this).next($("#help-block-phone")).html("");
		}else{
			$(this).parent().attr("class","input-icon right");
       		$(this).parent().children("#icon-exclamation-sign").attr("class","icon-exclamation-sign");	   
       		$(this).parent().parent().attr("class","has-error");
      	    $(this).next($("#help-block-phone")).html("يجب أن يكون رقم الهاتف مكون من 9 أرقام");
		}
	}else{
	   $(this).parent().attr("class","input-icon right");
       $(this).parent().children("#icon-exclamation-sign").attr("class","icon-exclamation-sign");	   
       $(this).parent().parent().attr("class","has-error");
       $(this).next($("#help-block-phone")).html("يجب أن يحتوي التص المدخل على أرقام فقط");
	}
});
//
$(".valid_select").click(function(){
    $(this).parent().parent().attr("class","");
    NoFind = $(this).val();
	if(NoFind != 0) {
	   $(this).parent().attr("class","input-icon right");
       $(this).parent().parent().attr("class","has-success");
	}else{
	   $(this).parent().attr("class","input-icon right");	   
       $(this).parent().parent().attr("class","has-error");
	}
});
/* Validation Input  */
/// function 
function ShowDataTableForForm(){
	 $("#sample_5").DataTable({
			"oLanguage": {
				"sProcessing": "جارٍ التحميل...",
				"sLengthMenu": "أظهر _MENU_ مدخلات",
				"sZeroRecords": "لم يعثر على أية سجلات",
				"sInfo": "إظهار _START_ إلى _END_ من أصل _TOTAL_ مدخل",
				"sInfoEmpty": "يعرض 0 إلى 0 من أصل 0 سجل",
				"sInfoFiltered": "(منتقاة من مجموع _MAX_ مُدخل)",
				"sInfoPostFix": "",
				"sSearch": "ابحث:",
				"sUrl": "",
				"oPaginate": {
					"sFirst": "الأول",
					"sPrevious": "السابق",
					"sNext": "التالي",
					"sLast": "الأخير"
				}
			}
	 });
}