// Function get Modal GIS With update




function arcgisviewMap( ){


	require([
			"esri/rest/find",
			"esri/rest/support/FindParameters",
			"esri/widgets/FeatureTable",
			"esri/layers/FeatureLayer",
			"esri/portal/Portal",
			"esri/identity/OAuthInfo",
			"esri/identity/IdentityManager",
			"esri/Graphic",
			"esri/Map",
			"esri/views/MapView"
		],
		function (find, FindParameters,FeatureTable,FeatureLayer,Portal, OAuthInfo, esriId,Graphic,Map,MapView) {

			const featureLayer = new FeatureLayer({
				url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
				title: "تم العثور على",

				outFields: ["*"]

			});

			const map = new Map({
				basemap: "dark-gray-vector",
				layers: [featureLayer]
			});
			const view = new MapView({
				container: "MapView",
				map: map,
				center: [32.4065711,31.6136190898314],
				zoom: 7
			});

/******************
 *
 * listener
 *
 * **/
let		feature;
			view.on("click", (event) => {
				view.hitTest(event).then((response) => {
					console.log(response.results[0].graphic.attributes	);
					feature=response.results[0].graphic	;
					results_clicks = response.results[0].graphic.attributes	;
					document.getElementById("editArea").style.display = "block";
					$('#subscriber_no').val(results_clicks["SUBSCRIPTION_NO"]);
					$('#OBJECTID').val(results_clicks["OBJECTID"]);
					$('#METER_NO').val(results_clicks["METER_NO"]);
					$('#CUSTOMER_NAME').val(results_clicks["CUSTOMER_NAME"]);
					$('#SUBSCRIPTION_TYPE').val(results_clicks["SUBSCRIPTION_TYPE"]);
					$('#METER_TYPE').val(results_clicks["METER_TYPE"]);
					$('#FEEDING_TYPE').val(results_clicks["FEEDING_TYPE"]);
					$('#BUILDING_NO').val(results_clicks["BUILDING_NO"]);
					$('#PROPERTY_DESCRIPTION').val(results_clicks["PROPERTY_DESCRIPTION"]);
					$('#CUSTOMER_CABLE_CODE').val(results_clicks["CUSTOMER_CABLE_CODE"]);
					$('#POLE_MATERLAL_ID').val(results_clicks["POLE_MATERLAL_ID"]);
					$('#LTL_SWITCH_CODE').val(results_clicks["LTL_SWITCH_CODE"]);
					$('#CUSTOMER_STATUS').val(results_clicks["CUSTOMER_STATUS"]);
					$('#TRANSFORMER_NAME_AR').val(results_clicks["TRANSFORMER_NAME_AR"]);
					$('#STREET_NAME').val(results_clicks["STREET_NAME"]);
					$('#DISTRICT_NUMBER').val(results_clicks["DISTRICT_NUMBER"]);
					$('#NOTES').val(results_clicks["NOTES"]);
					$('#TRANSFORMER_CODE').val(results_clicks["TRANSFORMER_CODE"]);
					$('#CREATED_USER').val(results_clicks["CREATED_USER"]);
					$('#LAST_EDITED_USER').val(results_clicks["LAST_EDITED_USER"]);
					$('#LAST_EDITED_DATE').val(results_clicks["LAST_EDITED_DATE"]);
					$('#MUNICIPALITY').val(results_clicks["MUNICIPALITY"]);
					$('#METER_COMPANY').val(results_clicks["METER_COMPANY"]);
					$('#METER_DIGITS').val(results_clicks["METER_DIGITS"]);
					$('#BRANCH').val(results_clicks["BRANCH"]);
					$('#METER_BREAK').val(results_clicks["METER_BREAK"]);
					$('#METER_SEALS').val(results_clicks["METER_SEALS"]);
					$('#BOX_SEALS').val(results_clicks["BOX_SEALS"]);
					$('#BREAKER').val(results_clicks["BREAKER"]);
					$('#SOLAR_ENERGY').val(results_clicks["SOLAR_ENERGY"]);
					$('#METER_READING').val(results_clicks["METER_READING"]);
					$('#LAST_READ').val(results_clicks["LAST_READ"]);
					$('#LAST_MONTH_READ_DATE').val(results_clicks["LAST_MONTH_READ_DATE"]);
					$('#LAST_CONSUMPTION').val(results_clicks["LAST_CONSUMPTION"]);
					$('#UPDATE_USER').val(results_clicks["UPDATE_USER"]);
					$('#UPDATE_DATE').val(results_clicks["UPDATE_DATE"]);
					$('#objectID').val(results_clicks["OBJECTID"]);

					const editThisAction = {
						title: "تعديل",
						id: "edit-this",
						className: "esri-icon-edit"
					};


					let popup = {
						title: "التفاصيل",
						content:'<input type=\"button\" onclick=\"updateFeature1('+results_clicks["OBJECTID"]+','+'olalfi'+')\" value="ooooo"/>'+ results_clicks["OBJECTID"]+'<br> رقم الاشتراك '+results_clicks["SUBSCRIPTION_NO"]+'<br> نوع الاشتراك :'+results_clicks["SUBSCRIPTION_TYPE"]+'<br> رقم المبنى : '+results_clicks["BUILDING_NO"]+'<br> اخر تعديل :'+results_clicks["NOTES"]
						//,
						//actions: [editThisAction]
					}


					featureLayer.popupTemplate=popup;
					view.popup.open({
						features:feature,
						location: response.results[0].graphic.geometry
					});
					var flag=0;
					view.popup.on("trigger-action", (event) => {
						if (event.action.id === "edit-this"&& flag!=1) {
							//console.log(results_clicks["OBJECTID"]);
							updateFeature1(results_clicks["OBJECTID"],"olalfi");
							flag=1;

						}
					});




				});



			});




		});






}
/**************************************
 *
 *
 * الخريطة اللي تحت ف الفوووتر
 *
 *
 *
 *
 */
function goToFeature(where_con){


	require([
			"esri/rest/find",
			"esri/rest/support/FindParameters",
			"esri/widgets/FeatureTable",
			"esri/layers/FeatureLayer",
			"esri/portal/Portal",
			"esri/identity/OAuthInfo",
			"esri/identity/IdentityManager",
			"esri/Graphic",
			"esri/Map",
			"esri/views/MapView",
			"esri/widgets/Search","esri/rest/support/Query"
		],
		function (find, FindParameters,FeatureTable,FeatureLayer,Portal, OAuthInfo, esriId,Graphic,Map,MapView,Search,Query) {
document.getElementById("MapView").innerHTML='';
			const featureLayer = new FeatureLayer({
				url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
				title: "تم العثور على",

				outFields: ["*"]

			});

			const map = new Map({
				basemap: "dark-gray-vector"
			//	,				layers: [featureLayer]
			});
			const view = new MapView({
				container: "MapView",
				map:map,
				center: [32.4065711,31.6136190898314],
				zoom: 7
			});
			featureLayer.load().then(function (){
               console.log("test");
				map.add(featureLayer);
				view.map=map;













				const query = new Query({
					outFields: ["*"],
					where: where_con,
					returnGeometry:true
				});
				featureLayer.queryFeatures(query)
					.then(function(response){
						var feature = response.features[0];
						var results_clicks=response.features[0].attributes;



						console.log(response);
						//console.log(arr);
						view.whenLayerView(featureLayer).then((layerView) => {

							layerView.highlight(feature)



						});
						view.goTo(
							{
								target: feature.geometry,
								tilt: 70,
								zoom: 20
							},
							{
								duration: 2000,
								easing: "in-out-expo"
							}
						).catch((error) => {
							if (error.name != "AbortError"){
								//console.error(error);
							}
						});




						GeneralShowMaploading();

						featureLayer.load().then(function () {
							console.log(featureLayer.isTable );

						});
						setTimeout(function(){
							let popup = {
								title: "التفاصيل",
								content:'<input type=\"button\" onclick=\"updateFeature1('+results_clicks["OBJECTID"]+','+'olalfi'+')\" value="ooooo"/>'+ results_clicks["OBJECTID"]+'<br> رقم الاشتراك '+results_clicks["SUBSCRIPTION_NO"]+'<br> نوع الاشتراك :'+results_clicks["SUBSCRIPTION_TYPE"]+'<br> رقم المبنى : '+results_clicks["BUILDING_NO"]+'<br> اخر تعديل :'+results_clicks["NOTES"]
								//,
								//actions: [editThisAction]
							}
							featureLayer.popupTemplate=popup;
							GeneralHideMaploading()
							view.popup.open({
								features:feature,
								location: feature.geometry
							});

						},10500);

					});


			});









		});


}

function arcgis_map(where_con,userid){

	var featureMatrix; // [...attributes, esrigeojson]

	require([
			"esri/rest/find",
			"esri/rest/support/FindParameters",
			"esri/widgets/FeatureTable",
			"esri/layers/FeatureLayer",
			"esri/portal/Portal",
			"esri/identity/OAuthInfo",
			"esri/identity/IdentityManager",
			"esri/Graphic"
		],
		function (find, FindParameters,FeatureTable,FeatureLayer,Portal, OAuthInfo, esriId,Graphic) {

			const featureLayer = new FeatureLayer({
				url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/MV_North/FeatureServer/3",
				title: "تم العثور على",
				definitionExpression: where_con,

				outFields: ["*"]

			});

			const featureTable = new FeatureTable({
				layer: featureLayer,
				multiSortEnabled: true, // set this to true to enable sorting on multiple columns
				editingEnabled: true,

				container: document.getElementById("tableDiv")
			});

			let features=[];


			featureTable.on("selection-change", (changes) => {
				// if the feature is unselected then remove the objectId
				// of the removed feature from the features array
				changes.removed.forEach((item) => {
					const data = features.find((data) => {
						return data === item.objectId;
					});
					if (data) {
						features.splice(features.indexOf(data), 1);
					}
				});

				// If the selection is added, push all added selections to array
				changes.added.forEach((item) => {

					//console.log(item);


					features.push(item.objectId);
				});

				// set excluded effect on the features that are not selected in the table
			});

			let editFeature;

			featureLayer.queryFeatures(featureLayer.createQuery()).then(fs => {
				//console.log('Number of rows: '+fs.features.length);
				//console.log(fs.features[0].geometry);
				featureMatrix = fs.features.map(g =>
					[...Object.values(g.attributes), g.geometry.toJSON()]

				);

				for(var i=0;i<featureMatrix.length;i++){
					var arr =	JSON.parse(JSON.stringify(featureMatrix[i]));
					editFeature = new Graphic({
						geometry: {"x":arr[0]['x'],"y":arr[0]['y']},
						attributes: {
							IncidentType: 1
						}
					});
					const edits = {
						addFeatures: [editFeature]
					};
					editFeature.attributes["NOTES"] =userid ;

					featureLayer
						.queryFeatures({
							objectIds: [arr[0]],
							outFields: ["*"],
							returnGeometry: true
						})
						.then((results) => {
							if (results.features.length > 0) {
								editFeature = results.features[0];

								//console.log(editFeature.attributes);

								editFeature.attributes["NOTES"] = "1831";
								const edits = {
									updateFeatures: [editFeature]
								};
								featureLayer
									.applyEdits(edits)
									.then((editsResult) => {
										//console.log(editsResult);
									})
									.catch((error) => {
										//console.log("error = ", error);
									});

							}
						});

					$('#dataToUpdate').append("<tr><td><input value='"+arr[0]+"'/></td><td><input value='"+arr[1]+"'/></td><td><input value='"+arr[2]+"'/></td><td><input value='"+arr[3]+"'/></td><td><input value='"+arr[4]+"'/></td><td><input value='"+arr[5]+"'/></td><td><input value='"+arr[6]+"'/></td><td><input value='"+arr[7]+"'/></td><td><input value='"+arr[8]+"'/></td>");
					$('#dataToUpdate').append("<td><input value='"+arr[10]+"'/></td><td><input value='"+arr[11]+"'/></td><td><input value='"+arr[12]+"'/></td><td><input value='"+arr[13]+"'/></td><td><input value='"+arr[14]+"'/></td><td><input value='"+arr[15]+"'/></td><td><input value='"+arr[16]+"'/></td><td><input value='"+arr[17]+"'/></td><td><input value='"+arr[18]+"'/></td>");
					$('#dataToUpdate').append("<td><input value='"+arr[19]+"'/></td><td><input value='"+arr[20]+"'/></td><td><input value='"+arr[21]+"'/></td><td><input value='"+arr[22]+"'/></td><td><input value='"+arr[23]+"'/></td><td><input value='"+arr[24]+"'/></td><td><input value='"+arr[25]+"'/></td><td><input value='"+arr[26]+"'/></td><td><input value='"+arr[27]+"'/></td></tr>");

				}
			});





		});



	return featureMatrix;



}


//withupdate
/// عند ما يعمل تسجيل دخول
function arcgis_map_update(where_con,userid){

	var featureMatrix; // [...attributes, esrigeojson]

	require([
			"esri/rest/find",
			"esri/rest/support/FindParameters",
			"esri/widgets/FeatureTable",
			"esri/layers/FeatureLayer",
			"esri/portal/Portal",
			"esri/identity/OAuthInfo",
			"esri/identity/IdentityManager",
			"esri/Graphic",
			"esri/Map",
			"esri/views/MapView"
		],
		function (find, FindParameters,FeatureTable,FeatureLayer,Portal, OAuthInfo, esriId,Graphic,Map,MapView) {
// الحصول على معلومات الاشتراك من طبقة الاششتراكات
			const featureLayer = new FeatureLayer({
				url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
				title: "تم العثور على",
				definitionExpression: where_con,
				outFields: ["*"]
			});
			const map = new Map({
				basemap: "dark-gray-vector",
				layers: [featureLayer]
			});
			const view = new MapView({
				container: "viewDiv",
				map: map,
				center: [32.4065711,31.6136190898314],
				zoom: 7
			});


			let editFeature,objectID=-1;



			featureLayer.queryFeatures(featureLayer.createQuery()).then(fs => {

				if(fs.features.length>0) {
					var arr = fs.features[0].attributes;
					objectID = arr["OBJECTID"];
					feature=fs.features[0];

					console.log(feature);

					document.getElementById("dataToUpdate").innerHTML='<tr><td><input class="form-control" value="' + arr["OBJECTID"] + '"/></td><td><input class="form-control" value=" ' + arr["SUBSCRIPTION_NO"] + '"/></td><td><input class="form-control" value="' + arr["CUSTOMER_NAME"] + '"/></td><td><input class="form-control" value="' + arr["STREET_NAME"] + '"/></td><td><input readonly class="form-control" value="' + arr["NOTES"] + '"/></td><td><input readonly class=\'form-control\' type=\'button\' id=\'viesGisDetails\' value=\'عرض التفاصيل\' onclick=\'view_map('+where_con+',\"'+arr["OBJECTID"]+'\")\' /></td></tr>';


					$('#gisModal').modal("show");

				}
				else danger_msg("تحذير","لا يوجد بيانات GIS لهذا الاشتراك");
			});



			$('#updates').on('click',function(){
				if (objectID!=-1) {
					featureLayer
						.queryFeatures({
							objectIds: [objectID],
							outFields: ["*"],
							returnGeometry: true
						})
						.then((results) => {
							if (results.features.length > 0) {
								editFeature = results.features[0];

								//console.log(editFeature.attributes);

								editFeature.attributes["NOTES"] = userid;
								const edits = {
									updateFeatures: [editFeature]
								};
								featureLayer
									.applyEdits(edits)
									.then((editsResult) => {
										//console.log(editsResult);
										if (editsResult.addFeatureResults.length > 0 || editsResult.updateFeatureResults.length > 0) {
											ShowSuccessMessage();
											success_msg("رسالة", "تم التعديل بنجاح")
											$("#gisModal").modal('hide');
											objectID=-1;
										}


									})
									.catch((error) => {
										danger_msg("تحذير", "" + error);
										//console.log("error = ", error);
									});


							}
						});
				}
			});
		});

	return featureMatrix;

}

/// function view map
/// عند ما يعمل عرض التفاصيل لمعلومات gis
function view_map(where_con,objectid){
	let results_clicks = [];
	require([
		"esri/Map",
		"esri/views/MapView",
		"esri/layers/FeatureLayer",
		"esri/Graphic",
		"esri/widgets/Expand",
		"esri/widgets/FeatureForm",
		"esri/widgets/FeatureTemplates",
		"esri/widgets/Search"
	], (Map, MapView, FeatureLayer, Graphic, Expand, FeatureForm, FeatureTemplates,Search) => {



		const featureLayer = new FeatureLayer({
			url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
			title: "تم العثور على",

			outFields: ["*"]

		});
		const map = new Map({
			basemap: "dark-gray-vector",
			layers: [featureLayer]
		});
		const view = new MapView({
			container: "viewDiv",
			map: map,
			center: [32.4065711,31.6136190898314],
			zoom: 7
		});
		$("#myModal").modal('show');

		setTimeout(function () {
			$("#myModal").modal('hide');
		}, 5000);
		featureLayer
			.queryFeatures({
				objectIds: [objectid],
				outFields: ["*"],
				returnGeometry: true
			})
			.then((results) => {
				var feature=results.features[0];
console.log(results);
				view.on("click", (event) => {
					view.hitTest(event).then((response) => {
						console.log(response.results[0].graphic.attributes	);
						feature=response.results[0].graphic	;
						results_clicks = response.results[0].graphic.attributes	;
						document.getElementById("editArea").style.display = "block";
						$('#subscriber_no').val(results_clicks["SUBSCRIPTION_NO"]);
						$('#OBJECTID').val(results_clicks["OBJECTID"]);
						$('#METER_NO').val(results_clicks["METER_NO"]);
						$('#CUSTOMER_NAME').val(results_clicks["CUSTOMER_NAME"]);
						$('#SUBSCRIPTION_TYPE').val(results_clicks["SUBSCRIPTION_TYPE"]);
						$('#METER_TYPE').val(results_clicks["METER_TYPE"]);
						$('#FEEDING_TYPE').val(results_clicks["FEEDING_TYPE"]);
						$('#BUILDING_NO').val(results_clicks["BUILDING_NO"]);
						$('#PROPERTY_DESCRIPTION').val(results_clicks["PROPERTY_DESCRIPTION"]);
						$('#CUSTOMER_CABLE_CODE').val(results_clicks["CUSTOMER_CABLE_CODE"]);
						$('#POLE_MATERLAL_ID').val(results_clicks["POLE_MATERLAL_ID"]);
						$('#LTL_SWITCH_CODE').val(results_clicks["LTL_SWITCH_CODE"]);
						$('#CUSTOMER_STATUS').val(results_clicks["CUSTOMER_STATUS"]);
						$('#TRANSFORMER_NAME_AR').val(results_clicks["TRANSFORMER_NAME_AR"]);
						$('#STREET_NAME').val(results_clicks["STREET_NAME"]);
						$('#DISTRICT_NUMBER').val(results_clicks["DISTRICT_NUMBER"]);
						$('#NOTES').val(results_clicks["NOTES"]);
						$('#TRANSFORMER_CODE').val(results_clicks["TRANSFORMER_CODE"]);
						$('#CREATED_USER').val(results_clicks["CREATED_USER"]);
						$('#LAST_EDITED_USER').val(results_clicks["LAST_EDITED_USER"]);
						$('#LAST_EDITED_DATE').val(results_clicks["LAST_EDITED_DATE"]);
						$('#MUNICIPALITY').val(results_clicks["MUNICIPALITY"]);
						$('#METER_COMPANY').val(results_clicks["METER_COMPANY"]);
						$('#METER_DIGITS').val(results_clicks["METER_DIGITS"]);
						$('#BRANCH').val(results_clicks["BRANCH"]);
						$('#METER_BREAK').val(results_clicks["METER_BREAK"]);
						$('#METER_SEALS').val(results_clicks["METER_SEALS"]);
						$('#BOX_SEALS').val(results_clicks["BOX_SEALS"]);
						$('#BREAKER').val(results_clicks["BREAKER"]);
						$('#SOLAR_ENERGY').val(results_clicks["SOLAR_ENERGY"]);
						$('#METER_READING').val(results_clicks["METER_READING"]);
						$('#LAST_READ').val(results_clicks["LAST_READ"]);
						$('#LAST_MONTH_READ_DATE').val(results_clicks["LAST_MONTH_READ_DATE"]);
						$('#LAST_CONSUMPTION').val(results_clicks["LAST_CONSUMPTION"]);
						$('#UPDATE_USER').val(results_clicks["UPDATE_USER"]);
						$('#UPDATE_DATE').val(results_clicks["UPDATE_DATE"]);
						$('#objectID').val(results_clicks["OBJECTID"]);

						const editThisAction = {
							title: "تعديل",
							id: "edit-this",
							className: "esri-icon-edit"
						};


						let popup = {
							title: "التفاصيل",
							content:'<input type=\"button\" onclick=\"updateFeature1('+results_clicks["OBJECTID"]+','+'olalfi'+')\" value="ooooo"/>'+ results_clicks["OBJECTID"]+'<br> رقم الاشتراك '+results_clicks["SUBSCRIPTION_NO"]+'<br> نوع الاشتراك :'+results_clicks["SUBSCRIPTION_TYPE"]+'<br> رقم المبنى : '+results_clicks["BUILDING_NO"]+'<br> اخر تعديل :'+results_clicks["NOTES"]
							//,
							//actions: [editThisAction]
						}


						featureLayer.popupTemplate=popup;
						view.popup.open({
							features:feature,
							location: response.results[0].graphic.geometry
						});
var flag=0;
						view.popup.on("trigger-action", (event) => {
							if (event.action.id === "edit-this"&& flag!=1) {
								//console.log(results_clicks["OBJECTID"]);
								updateFeature1(results_clicks["OBJECTID"],"olalfi");
								flag=1;

							}
						});




					});



				});
				view.popup.open({
					features:feature,
					location: feature.geometry
				});

				view.goTo(
					{
						target: feature.geometry,
						tilt: 70,
						zoom: 20
					},
					{
						duration: 2000,
						easing: "in-out-expo"
					}
				).catch((error) => {
					if (error.name != "AbortError"){
						//console.error(error);
					}
				});
			});





		$("#MapModal").modal("show");


		/**************************تعديل التفاصيل *************************/


	});
}
/// function load gis portal
function load_gis_portal(where_con,userid){
	require([
			"esri/rest/find",
			"esri/rest/support/FindParameters",
			"esri/widgets/FeatureTable",
			"esri/layers/FeatureLayer",
			"esri/portal/Portal",
			"esri/identity/OAuthInfo",
			"esri/identity/IdentityManager" ],
		function (find, FindParameters,FeatureTable,FeatureLayer,Portal, OAuthInfo, esriId){
			const info = new OAuthInfo({
				appId: "3iGr8dQ1ZKuczuAT",
				popup: false,
				portalUrl: "https://gisportal.gedco.ps:6443/portal",
				redirect_uri: "http://localhost/commercial"// the default
			});
			esriId.registerOAuthInfos([info]);

			esriId.getCredential("https://gisportal.gedco.ps/portal" + "/sharing");
			arcgis_map_update(where_con,userid);

			esriId
				.checkSignInStatus(info.portalUrl + "/sharing")
				.then(() => {
					//  handleSignedIn();
				})

				.catch(() => {
					//  handleSignedOut();

				});

		});
}
//// function update feature
/*
function updateFeature(objectID1,userid){
	console.log(objectID1);
	require([
			"esri/rest/find",
			"esri/rest/support/FindParameters",
			"esri/widgets/FeatureTable",
			"esri/layers/FeatureLayer",
			"esri/portal/Portal",
			"esri/identity/OAuthInfo",
			"esri/identity/IdentityManager" ],
		function (find, FindParameters,FeatureTable,FeatureLayer,Portal, OAuthInfo, esriId) {
			const featureLayer = new FeatureLayer({
				url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
				title: "تم العثور على",

				outFields: ["*"]

			});


			featureLayer
				.queryFeatures({
					objectIds: [objectID1],
					outFields: ["*"],
					returnGeometry: true
				})
				.then((results) => {
					//console.log(results);
					if (results.features.length > 0) {
						let editFeature = results.features[0];
						editFeature.attributes["NOTES"] = userid;
						const edits = {
							updateFeatures: [editFeature]
						};
						console.log(editFeature.attributes);

						featureLayer
							.applyEdits(edits)
							.then((editsResult) => {
								//console.log(editsResult);
								if (editsResult.addFeatureResults.length > 0 || editsResult.updateFeatureResults.length > 0) {
									ShowSuccessMessage();
									success_msg("رسالة", "تم التعديل بنجاح")
									//$("#gisModal").modal('hide');
									objectID1 = -1;
								}


							})
							.catch((error) => {
								danger_msg("تحذير", "" + error);
								//console.log("error = ", error);
							});


					}
				});
















	});

}
*/


//فنكشن لعرض البيانات على الشاشة
function addIssueInGIS(where_con,userid){
let point;
	require([
		"esri/Map",
		"esri/views/MapView",
		"esri/layers/FeatureLayer",
		"esri/Graphic",
		"esri/widgets/Expand",
		"esri/widgets/FeatureForm",
		"esri/widgets/FeatureTemplates",
		"esri/widgets/Search","esri/rest/support/Query"
	], (Map, MapView, FeatureLayer, Graphic, Expand, FeatureForm, FeatureTemplates,Search,Query) =>
	{

		const featureLayer = new FeatureLayer({
			url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
			title: "تم العثور على",
			outFields: ["*"]

		});

		const map = new Map({
			basemap: "dark-gray-vector",
			layers: [featureLayer]
		});
		const view = new MapView({
			container: "viewDiv",
			map: map,
			center: [32.4065711,31.6136190898314],
			zoom: 7
		});


var feature=[];



		const query = new Query({
			outFields: ["*"],
			where: where_con,
			returnGeometry:true
		});
		featureLayer.queryFeatures(query)
			.then(function(response){
				if(response.features.length>0){
					  arr = response.features[0].attributes;
console.log(response.features[0].geometry);



					point=response.features[0].geometry;

					success_msg("رسالة","يوجد بيانات في قاعدة بيانات gis خاصة بهذا الاشتراك")
					if(confirm("يوجد بيانات في قاعدة بيانات gis خاصة بهذا الاشتراك .هل تريد استعراضها ؟")){

						document.getElementById("dataToUpdate").innerHTML= '<tr><td><input class="form-control" value="' + arr["OBJECTID"] + '"/></td><td><input class="form-control" value=" ' + arr["SUBSCRIPTION_NO"] + '"/></td><td><input class="form-control" value="' + arr["CUSTOMER_NAME"] + '"/></td><td><input class="form-control" value="' + arr["STREET_NAME"] + '"/></td><td><input readonly class="form-control" value="' + arr["NOTES"] + '"/></td><td><input readonly class=\'form-control\' type=\'button\' id=\'viesGisDetails\' value=\'عرض التفاصيل\' onclick=\'view_map('+where_con+',\"'+ arr["OBJECTID"]+'\")\' /></td></tr>';
						$('#gisModal').modal("show");



					}

				}
				else {danger_msg("تحذير","لا يوجد معلومات gis")}
			//	console.log(response.features[0].attributes);




				// process the results
			});


	});





return point;



}
function updateFeature1(objectID1,userid){
	alert(objectID1);
	require(["esri/rest/find", "esri/rest/support/FindParameters","esri/widgets/FeatureTable","esri/layers/FeatureLayer", "esri/portal/Portal",
			"esri/identity/OAuthInfo",
			"esri/identity/IdentityManager" ],
		function (find, FindParameters,FeatureTable,FeatureLayer,Portal, OAuthInfo, esriId) {
			const featureLayer = new FeatureLayer({
				url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
				title: "تم العثور على",

				outFields: ["*"]

			});
			featureLayer
				.queryFeatures({
					objectIds: [objectID1],
					outFields: ["*"],
					returnGeometry: true
				})
				.then((results) => {
					console.log(results);
					if (results.features.length > 0 &&objectID1!=-1) {
						let editFeature = results.features[0];

						console.log(editFeature.attributes);

						editFeature.attributes["NOTES"] = userid;
						const edits = {
							updateFeatures: [editFeature]
						};
						if ( objectID1!=-1) {
							applyEditsToIncidents(edits);
							/*	featureLayer
									.applyEdits(edits)
									.then((editsResult) => {
										console.log(editsResult);
										if (editsResult.addFeatureResults.length > 0 || editsResult.updateFeatureResults.length > 0) {
											ShowSuccessMessage();
											success_msg("رسالة", "تم التعديل بنجاح");
											console.log(editsResult);
											//$("#gisModal").modal('hide');
											objectID1 = -1;
										}


									})
									.catch((error) => {
										danger_msg("تحذير", "" + error);
										console.log("error = ", error);
									});*/

						}
					}
				});
			function applyEditsToIncidents(params) {
				featureLayer
					.applyEdits(params)
					.then((editsResult) => {
						console.log(editsResult);

						// Get the objectId of the newly added feature.
						// Call selectFeature function to highlight the new feature.
						if (editsResult.addFeatureResults.length > 0 || editsResult.updateFeatureResults.length > 0) {
							let objectId;
							if (editsResult.addFeatureResults.length > 0) {



								objectId = editsResult.addFeatureResults[0].objectId;

								featureLayer2
									.queryFeatures({
										objectIds: [objectId],
										outFields: ["*"],
										returnGeometry: true
									})
									.then((results) => {
										var TXT_P_SER_NO = $('#TXT_P_SER_NO').val();
										var TXT_P_SER_NO_OLD = $('#TXT_P_SER_NO_OLD').val();
										var TXT_P_DATE = $('#TXT_P_DATE').val();
										var TXT_SER_BOCK_NO = $('#TXT_SER_BOCK_NO').val();
										var TXT_SUBSCRIBER = $('#TXT_SUBSCRIBER').val();
										var TXT_NAME = $('#TXT_NAME').val();
										var TXT_ADD_ = $('#TXT_ADD_').val();
										var TXT_FEEDER_TRANS = $('#TXT_FEEDER_TRANS').val();
										var TXT_FEEDER_KNIFE = $('#TXT_FEEDER_KNIFE').val();
										var TXT_STEAL_DATAA = $('#TXT_STEAL_DATAA').val();
										var TXT_TRANSACTIONSA = $('#TXT_TRANSACTIONSA').val();
										var TXT_FROM_LOC = $('#TXT_FROM_LOC').val();
										var TXT_TO_LOC = $('#TXT_TO_LOC').val();
										var TXT_SUBSCRIBER_TYPE = $('#TXT_SUBSCRIBER_TYPE').val();
										var TXT_BRANCH = $('#BRANCH').val();
										var TXT_PROCESS_CASE = $('#TXT_PROCESS_CASE').val();

										var newArr = {P_SER_NO_OLD:TXT_P_SER_NO_OLD,P_SER_NO:TXT_P_SER_NO,P_DATE:TXT_P_DATE,SER_BOCK_NO:TXT_SER_BOCK_NO
											,SUBSCRIBER:TXT_SUBSCRIBER,NAME:TXT_NAME,ADD_:TXT_ADD_,FEEDER_TRANS:TXT_FEEDER_TRANS
											,FEEDER_KNIFE:TXT_FEEDER_KNIFE,STEAL_DATAA:TXT_STEAL_DATAA,TRANSACTIONSA:TXT_TRANSACTIONSA,
											FROM_LOC:TXT_FROM_LOC,TO_LOC:TXT_TO_LOC,SUBSCRIBER_TYPE:TXT_SUBSCRIBER_TYPE,BRANCH:TXT_BRANCH,PROCESS_CASE:TXT_PROCESS_CASE};

										var   attributes=[
											{
												"geometry": {
													"x": point.x,
													"y": point.y
												},
												"attributes": [newArr]
											}
										];
										/*	editFeature = new Graphic({
                                                geometry: point,
                                                attributes:attributes

                                            });*/
										//	results.features[0].attributes=newArr;
										results.features[0].attributes['SUBSCRIBER']=$('#TXT_SUBSCRIBER').val();
										results.features[0].attributes['NAME']=TXT_NAME;
										results.features[0].attributes['P_DATE']=TXT_P_DATE;
										results.features[0].attributes['ADD_']=TXT_ADD_;
										results.features[0].attributes['FEEDER_TRANS']=TXT_FEEDER_TRANS;
										results.features[0].attributes['LOC']=TXT_TO_LOC;
										results.features[0].attributes['SUBSCRIBER_TYPE']=TXT_SUBSCRIBER_TYPE;

										editFeature = new Graphic({
											geometry: point,
											attributes:results.features[0].attributes

										});

										console.log(point.x);
										console.log("new Att",editFeature.attributes);

										const edits = {
											updateFeatures: [editFeature]
										};

										console.log(editFeature.attributes);





										applyEditsToIncidents(edits);



									});










							} else {
								console.log(editsResult);

								objectId = editsResult.updateFeatureResults[0].objectId;
							}
							console.log(objectId);
						}

					})
					.catch((error) => {
						console.log("error = ", error);
					});
			}

		}
	);


}

/********************************************
 *
 *
 *
 * / فنكشن بتضيف على الطبقة الجديدة

 *
 *
 */
function  add_Issue(where_con,p_ser_no,username){
	require([
		"esri/Map",
		"esri/views/MapView",
		"esri/layers/FeatureLayer",
		"esri/Graphic",
		"esri/widgets/Expand",
		"esri/widgets/FeatureForm",
		"esri/widgets/FeatureTemplates",
		"esri/widgets/Search",
		"esri/rest/support/Query"
	], (Map, MapView, FeatureLayer, Graphic, Expand, FeatureForm, FeatureTemplates,Search,Query) =>
	{
		const featureLayer = new FeatureLayer({
			url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
			title: "تم العثور على",
			outFields: ["*"]

		});
		const featureLayer2 = new FeatureLayer({
			url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/process_tb/FeatureServer",
			title: "تم العثور على",
			outFields: ["*"]

		});
		const query = new Query({
			outFields: ["*"],
			where: where_con,
			returnGeometry:true
		});
		featureLayer.queryFeatures(query)
			.then(function(response){
				if(response.features.length>0) {

				point=response.features[0].geometry;

				//	response.features[0].geometry.hasZ = false;
					var TXT_P_DATE = $('#TXT_P_DATE').val();

					var TXT_SER_BOCK_NO = $('#TXT_SER_BOCK_NO').val();
					var TXT_NAME = $('#TXT_NAME').val();
					var TXT_ADD_ = $('#TXT_ADD_').val();
					var TXT_FEEDER_TRANS = $('#DL_FEEDER_TRANS').val();
					var TXT_FEEDER_KNIFE = $('#DL_FEEDER_KNIFE').val();
					var TXT_TO_LOC = $('#TXT_LOC').val();
					var TXT_SUBSCRIBER_TYPE = $('#TXT_SUBSCRIBER_TYPE').val();
					var TXT_BRANCH = $('#TXT_REQUEST_BRANCH_ID').val();
					var TXT_BOARD_CAPACITY = $('#TXT_BOARD_CAPACITY').val();
					var BOARD_TYPE = $('#DL_BOARD_TYPE').val() ;
					var TXT_ID_P = $('#TXT_ID_P').val() ;
					var CABLE_TYPE =  $('#DL_CABLE_TYPE').val();
					var CABLE_WIDTH =   $('#TXT_CABLE_WIDTH').val();
					var CABLE_POSITION =  $('#DL_CABLE_POSITION').val();
					var FLAT_NO = $('#TXT_FLAT_NO').val();
					var B_NAME = $('#TXT_B_NAME').val();





















/**



					response.features[0].attributes['SUBSCRIBER']=$('#TXT_SUBSCRIBER').val();
					response.features[0].attributes['NAME']=TXT_NAME;
					response.features[0].attributes['B_NAME']=B_NAME;
					response.features[0].attributes['P_SER_NO']=p_ser_no;
					response.features[0].attributes['P_DATE']=TXT_P_DATE;
					response.features[0].attributes['ADD_']=TXT_ADD_;
					response.features[0].attributes['ENTRY_USER']=username;
					response.features[0].attributes['created_user_N']=username;


					//رقم هوية المشترك
					 response.features[0].attributes['ID_P']=TXT_ID_P;
					//سعة اللوحة
					response.features[0].attributes['BOARD_CAPACITY']=TXT_BOARD_CAPACITY;
					//نوع اللوحة
					response.features[0].attributes['BOARD_TYPE']=BOARD_TYPE;
					//	response.features[0].attributes['NAME']=TXT_NAME;
					//العنوان
					response.features[0].attributes['ADD_']=TXT_ADD_;
					//المحول المغذي
					response.features[0].attributes['FEEDER_TRANS']=TXT_FEEDER_TRANS;
					//الموقع
					response.features[0].attributes['LOC']=TXT_TO_LOC;
					//نوع الاشتراك
					response.features[0].attributes['SUBSCRIBER_TYPE']=TXT_SUBSCRIBER_TYPE ;
					//حالة القضية
					response.features[0].attributes['V_PROCESS_CASE']=1;
					//رقم المحضر
					response.features[0].attributes['SER_BOCK_NO']=TXT_SER_BOCK_NO ;
					//سكينة التغذية
					response.features[0].attributes['FEEDER_KNIFE']=TXT_FEEDER_KNIFE ;
					//المقر
					response.features[0].attributes['BRANCH_ID']=TXT_BRANCH ;
					//نوع الكابل
					response.features[0].attributes['CABLE_TYPE']=CABLE_TYPE ;
					//سمك الكابل
					response.features[0].attributes['CABLE_WIDTH']=CABLE_WIDTH;
					//موقع الكابل
					response.features[0].attributes['CABLE_POSITION']=CABLE_POSITION ;
					//عدد الشقق
					response.features[0].attributes['FLAT_NO']=FLAT_NO;

*/


var   attributes=[
	{

		"attributes": {
			"SUBSCRIBER": $('#TXT_SUBSCRIBER').val(),
			"NAME": TXT_NAME,
			"B_NAME": B_NAME,
			"P_SER_NO": p_ser_no,
			"P_DATE": TXT_P_DATE,
			"ADD_": TXT_ADD_,
			"ENTRY_USER":username,
			"created_user_N":username,

		}
	}
];

					editFeature = new Graphic({
						geometry: response.features[0].geometry,
 						attributes: attributes


					});


					console.log("add to process",editFeature.attributes);

					const edits = {
						addFeatures: [editFeature]
					};


					console.log(edits);
					console.log("add1",editFeature);


					applyEditsToIncidents1(edits,p_ser_no,username);





				}
else{
	danger_msg("تحذير","لا يوجد معلومات لهذا الاشتراك في طبقة المشتركين");
				}



			});





		function applyEditsToIncidents1(params,p_ser_no,username) {
			featureLayer2
				.applyEdits(params)
				.then((editsResult) => {
/*
					editFeature = new Graphic({
						geometry: response.features[0].geometry,
						attributes: attributes


					});
					const edits = {
						updateFeatures: params.addFeatures[0]
					};
					console.log(edits);*/

					// Get the objectId of the newly added feature.
					// Call selectFeature function to highlight the new feature.
					if (editsResult.addFeatureResults.length > 0 || editsResult.updateFeatureResults.length > 0) {
						let objectId;
						if (editsResult.addFeatureResults.length > 0) {
							//console.log(editFeature.attributes);
							console.log(editsResult);
							objectId = editsResult.addFeatureResults[0].objectId;
							featureLayer2
								.queryFeatures({
									objectIds: [objectId],
									outFields: ["*"],
									returnGeometry: true
								})
								.then((results) => {



									console.log("ola",results);


									var TXT_P_DATE = $('#TXT_P_DATE').val();

									var TXT_SER_BOCK_NO = $('#TXT_SER_BOCK_NO').val();
									var TXT_NAME = $('#TXT_NAME').val();
									var TXT_ADD_ = $('#TXT_ADD_').val();
									var TXT_FEEDER_TRANS = $('#DL_FEEDER_TRANS').val();
									var TXT_FEEDER_KNIFE = $('#DL_FEEDER_KNIFE').val();
									var TXT_TO_LOC = $('#TXT_LOC').val();
									var TXT_SUBSCRIBER_TYPE = $('#TXT_SUBSCRIBER_TYPE').val();
									var TXT_BRANCH = $('#TXT_REQUEST_BRANCH_ID').val();
									var TXT_BOARD_CAPACITY = $('#TXT_BOARD_CAPACITY').val();
									var BOARD_TYPE = $('#DL_BOARD_TYPE').val() ;
									var TXT_ID_P = $('#TXT_ID_P').val() ;
									var CABLE_TYPE =  $('#DL_CABLE_TYPE').val();
									var CABLE_WIDTH =   $('#TXT_CABLE_WIDTH').val();
									var CABLE_POSITION =  $('#DL_CABLE_POSITION').val();
									var FLAT_NO = $('#TXT_FLAT_NO').val();
									var B_NAME = $('#TXT_B_NAME').val();

									results.features[0].attributes['SUBSCRIBER']=$('#TXT_SUBSCRIBER').val();
									results.features[0].attributes['NAME']=TXT_NAME;
									results.features[0].attributes['B_NAME']=B_NAME;
									results.features[0].attributes['P_SER_NO']=p_ser_no;
								//	results.features[0].attributes['P_DATE']=TXT_P_DATE;
									results.features[0].attributes['ADD_']=TXT_ADD_;
									results.features[0].attributes['ENTRY_USER']=username;

									//رقم هوية المشترك
									results.features[0].attributes['ID_P']=TXT_ID_P;
									//سعة اللوحة
									results.features[0].attributes['BOARD_CAPACITY']=parseFloat(TXT_BOARD_CAPACITY);
									//نوع اللوحة
						//////////////////////////////////		 	results.features[0].attributes['BOARD_TYPE']=BOARD_TYPE;
										results.features[0].attributes['NAME']=$('#TXT_NAME').val();
									//العنوان
										results.features[0].attributes['ADD_']=TXT_ADD_;
									//المحول المغذي
									results.features[0].attributes['FEEDER_TRANS']=TXT_FEEDER_TRANS;
									//الموقع
									results.features[0].attributes['LOC']=TXT_TO_LOC;
									//نوع الاشتراك
									results.features[0].attributes['SUBSCRIBER_TYPE']=TXT_SUBSCRIBER_TYPE ;
									//حالة القضية
									results.features[0].attributes['V_PROCESS_CASE']=1;
									//رقم المحضر
										results.features[0].attributes['SER_BOCK_NO']=parseFloat(TXT_SER_BOCK_NO) ;
									//سكينة التغذية
									results.features[0].attributes['FEEDER_KNIFE']=parseFloat(TXT_FEEDER_KNIFE) ;
									//المقر
										results.features[0].attributes['BRANCH_ID']=parseFloat(TXT_BRANCH) ;
									//نوع الكابل
									results.features[0].attributes['CABLE_TYPE']=parseFloat(CABLE_TYPE) ;
									//سمك الكابل
									results.features[0].attributes['CABLE_WIDTH']=CABLE_WIDTH;
									//موقع الكابل
									results.features[0].attributes['CABLE_POSITION']=parseFloat(CABLE_POSITION) ;
									//عدد الشقق
									results.features[0].attributes['FLAT_NO']=parseFloat(FLAT_NO);




									editFeature = new Graphic({
										geometry: point,
										attributes:results.features[0].attributes

									});

 									console.log("new Att",editFeature.attributes);

									const edits = {
										updateFeatures: [editFeature]
									};

									console.log(editFeature.attributes);





									applyEditsToIncidents1(edits,p_ser_no,username);




								});
/*

							objectId = editsResult.addFeatureResults[0].objectId;

							featureLayer2
								.queryFeatures({
									objectIds: [objectId],
									outFields: ["*"],
									returnGeometry: true
								})
								.then((results) => {
 									var TXT_P_DATE = $('#TXT_P_DATE').val();
									var TXT_SER_BOCK_NO = $('#TXT_SER_BOCK_NO').val();
 									var TXT_NAME = $('#TXT_NAME').val();
									var TXT_ADD_ = $('#TXT_ADD_').val();
									var TXT_FEEDER_TRANS = $('#DL_FEEDER_TRANS').val();
									var TXT_FEEDER_KNIFE = $('#DL_FEEDER_KNIFE').val();
									var TXT_TO_LOC = $('#TXT_LOC').val();
									var TXT_SUBSCRIBER_TYPE = $('#TXT_SUBSCRIBER_TYPE').val();
									var TXT_BRANCH = $('#TXT_BRANCH_ID').val();
 									var TXT_BOARD_CAPACITY = $('#TXT_BOARD_CAPACITY').val();
									var BOARD_TYPE = $('#DL_BOARD_TYPE').val() ;
									var TXT_ID_P = $('#TXT_ID_P').val() ;
									var CABLE_TYPE =  $('#DL_CABLE_TYPE').val();
									var CABLE_WIDTH =   $('#TXT_CABLE_WIDTH').val();
									var CABLE_POSITION =  $('#DL_CABLE_POSITION').val();
									var FLAT_NO = $('#TXT_FLAT_NO').val();
									var B_NAME = $('#TXT_B_NAME').val();


									results.features[0].attributes['SUBSCRIBER']=$('#TXT_SUBSCRIBER').val();
									results.features[0].attributes['NAME']=TXT_NAME;
									results.features[0].attributes['B_NAME']=B_NAME;
									results.features[0].attributes['P_SER_NO']=p_ser_no;
									results.features[0].attributes['P_DATE']=TXT_P_DATE;
									results.features[0].attributes['ADD_']=TXT_ADD_;
 									results.features[0].attributes['ENTRY_USER']=username;

									//رقم هوية المشترك
									results.features[0].attributes['ID_P']=TXT_ID_P;
									//سعة اللوحة
									results.features[0].attributes['BOARD_CAPACITY']=TXT_BOARD_CAPACITY;
									//نوع اللوحة
									results.features[0].attributes['BOARD_TYPE']=BOARD_TYPE;
									//	results.features[0].attributes['NAME']=TXT_NAME;
									//العنوان
									results.features[0].attributes['ADD_']=TXT_ADD_;
									//المحول المغذي
									results.features[0].attributes['FEEDER_TRANS']=TXT_FEEDER_TRANS;
									//الموقع
									results.features[0].attributes['LOC']=TXT_TO_LOC;
									//نوع الاشتراك
									results.features[0].attributes['SUBSCRIBER_TYPE']=TXT_SUBSCRIBER_TYPE ;
									//حالة القضية
									results.features[0].attributes['V_PROCESS_CASE']=1;
									//رقم المحضر
									results.features[0].attributes['SER_BOCK_NO']=TXT_SER_BOCK_NO ;
									//سكينة التغذية
									results.features[0].attributes['FEEDER_KNIFE']=TXT_FEEDER_KNIFE ;
									//المقر
									results.features[0].attributes['BRANCH_ID']=TXT_BRANCH ;
									//نوع الكابل
									results.features[0].attributes['CABLE_TYPE']=CABLE_TYPE ;
									//سمك الكابل
									results.features[0].attributes['CABLE_WIDTH']=CABLE_WIDTH;
									//موقع الكابل
									results.features[0].attributes['CABLE_POSITION']=CABLE_POSITION ;
									//عدد الشقق
									results.features[0].attributes['FLAT_NO']=FLAT_NO;




									editFeature = new Graphic({
										geometry: point,
										attributes:results.features[0].attributes

									});

									console.log(point.x);
									console.log("new Att",editFeature.attributes);

									const edits = {
										updateFeatures: [editFeature]
									};

									console.log(editFeature.attributes);





									applyEditsToIncidents(edits,p_ser_no,username);



								});




*/





						} else {
							console.log(editsResult);

							objectId = editsResult.updateFeatureResults[0].objectId;
							ShowSuccessMessage();
							console.log("add",p_ser_no);
						//	get_to_link('/'+_base_name+'/EditIssues/'+p_ser_no);
							//  get_to_link('/'+_base_name+'/EditIssues/'+element['o_msgtxt']);
						}
						console.log(objectId);
					}

				})
				.catch((error) => {
					console.log("error = ", error);
				});
		}

	});






}

function updateIssue(p_ser_no,subscriber_no,username){
	require([
		"esri/Map",
		"esri/views/MapView",
		"esri/layers/FeatureLayer",
		"esri/Graphic",
		"esri/widgets/Expand",
		"esri/widgets/FeatureForm",
		"esri/widgets/FeatureTemplates",
		"esri/widgets/Search",
		"esri/rest/support/Query"
	], (Map, MapView, FeatureLayer, Graphic, Expand, FeatureForm, FeatureTemplates,Search,Query) => {

		const featureLayer2 = new FeatureLayer({
			url: "https://gisserver.gedco.ps:6443/arcgis/rest/services/GIS_GEDCO1/process_tb/FeatureServer",
			title: "تم العثور على",
			outFields: ["*"]

		});
		const query = new Query({
			outFields: ["*"],
			where: "P_SER_NO ="+p_ser_no,
			returnGeometry: true
		});
		var TXT_P_SER_NO = $('#TXT_P_SER_NO').val();
		var TXT_P_SER_NO_OLD = $('#TXT_P_SER_NO_OLD').val();
		var TXT_P_DATE = $('#TXT_P_DATE').val();
		var TXT_SER_BOCK_NO = $('#TXT_SER_BOCK_NO').val();
		var TXT_SUBSCRIBER = $('#TXT_SUBSCRIBER').val();
		var TXT_NAME = $('#TXT_NAME').val();
		var TXT_ADD_ = $('#TXT_ADD_').val();
		var TXT_FEEDER_TRANS = $('#DL_FEEDER_TRANS').val();
		var TXT_FEEDER_KNIFE = $('#DL_FEEDER_KNIFE').val();
		var TXT_TO_LOC = $('#TXT_LOC').val();
		var TXT_SUBSCRIBER_TYPE = $('#TXT_SUBSCRIBER_TYPE').val();
		var TXT_BRANCH = $('#TXT_REQUEST_BRANCH_ID').val();
		var TXT_PROCESS_CASE = $('#TXT_V_PROCESS_CASE').val();
		var TXT_BOARD_CAPACITY = $('#TXT_BOARD_CAPACITY').val();
		var BOARD_TYPE = $('#DL_BOARD_TYPE').val() ;
		var TXT_ID_P = $('#TXT_ID_P').val() ;
		var CABLE_TYPE =  $('#DL_CABLE_TYPE').val();
		var CABLE_WIDTH =   $('#TXT_CABLE_WIDTH').val();
		var CABLE_POSITION =  $('#DL_CABLE_POSITION').val();
		var FLAT_NO = $('#TXT_FLAT_NO').val();

		featureLayer2.queryFeatures(query)
			.then(function (response) {
				if (response.features.length > 0) {
					var SelectedFeature = response.features[0].attributes;
					console.log("featureToupdate",SelectedFeature)

					point = response.features[0].geometry;

					var attributes = [
						{
							"geometry": {
								"x": point.x,
								"y": point.y
							},
							"attributes": [SelectedFeature]
						}
					];

					editFeature = new Graphic({
						geometry: response.features[0].geometry,
						attributes: SelectedFeature

					});
				//	$('select[name="MAIN_STEAL_DATA"]')
				//	console.log($("select[name=MAIN_STEAL_DATA[]]").val());

					jQuery("select[name='MAIN_STEAL_DATA[]']").each(function() {
						console.log( this.value + ":"   );
					});
 					//رقم المشترك

					editFeature. attributes['SUBSCRIBER']=$('#TXT_SUBSCRIBER').val();
					//رقم هوية المشترك
					editFeature.attributes['ID_P']=TXT_ID_P;
					//سعة اللوحة
					editFeature.attributes['BOARD_CAPACITY']=TXT_BOARD_CAPACITY;
					//نوع اللوحة
					editFeature.attributes['BOARD_TYPE']=BOARD_TYPE;
				//	editFeature.attributes['NAME']=TXT_NAME;
					//العنوان
					editFeature.attributes['ADD_']=TXT_ADD_;
					//المحول المغذي
					editFeature.attributes['FEEDER_TRANS']=TXT_FEEDER_TRANS;
					//الموقع
					editFeature.attributes['LOC']=TXT_TO_LOC;
					//نوع الاشتراك
					editFeature.attributes['SUBSCRIBER_TYPE']=TXT_SUBSCRIBER_TYPE ;
					//حالة القضية
					editFeature.attributes['V_PROCESS_CASE']=1;
					//رقم المحضر
					editFeature.attributes['SER_BOCK_NO']=TXT_SER_BOCK_NO ;
					//سكينة التغذية
					editFeature.attributes['FEEDER_KNIFE']=TXT_FEEDER_KNIFE ;
					//المقر
					editFeature.attributes['BRANCH_ID']=TXT_BRANCH ;
					//نوع الكابل
					editFeature.attributes['CABLE_TYPE']=CABLE_TYPE ;
					//سمك الكابل
					editFeature.attributes['CABLE_WIDTH']=CABLE_WIDTH;
					//موقع الكابل
					editFeature.attributes['CABLE_POSITION']=CABLE_POSITION ;
					//عدد الشقق
					editFeature.attributes['FLAT_NO']=FLAT_NO;


					console.log("update Issues", editFeature.attributes);

					const edits = {
						updateFeatures: [editFeature]
					};
					console.log(edits);
					console.log("add1", p_ser_no);


					applyEditsToIncidents(edits, p_ser_no, username);


				}
			});

		function applyEditsToIncidents(params, p_ser_no, username) {
			console.log(params);

			featureLayer2
				.applyEdits(params)
				.then((editsResult) => {

					// Get the objectId of the newly added feature.
					// Call selectFeature function to highlight the new feature.
					if (editsResult.addFeatureResults.length > 0 || editsResult.updateFeatureResults.length > 0) {
						let objectId;
						if(editsResult.updateFeatureResults.length > 0)  {
							console.log(editsResult);

							objectId = editsResult.updateFeatureResults[0].objectId;
							ShowSuccessMessage();
							console.log("add", editsResult);
						//	get_to_link('/' + _base_name + '/EditIssues/' + p_ser_no);
						}
						console.log(objectId);
					}

				})
				.catch((error) => {
					console.log("error = ", error);
					console.log("error = ", error.content);
				});
		}

	});
}
function hidemodal(){
	$('#gisModal').modal('hide');

	console.log("gisModal");
}
function hidemodalMap(){
	$('#MapModal').modal('hide');
	$('#viewDiv').modal('hide');

	console.log("viewDiv");

}

function addsubscriberMap( SUBSCRIBER,url1,url2){


   require([
         "esri/rest/find",
         "esri/rest/support/FindParameters",
         "esri/widgets/FeatureTable",
         "esri/layers/FeatureLayer",
         "esri/portal/Portal",
         "esri/identity/OAuthInfo",
         "esri/identity/IdentityManager",
         "esri/Graphic",
         "esri/Map",
         "esri/views/MapView",
         "esri/widgets/Search",
         "esri/rest/support/Query",
         "esri/layers/GraphicsLayer",
         "esri/widgets/Feature"

      ],
      function (find, FindParameters,FeatureTable,FeatureLayer,Portal, OAuthInfo, esriId,Graphic,Map,MapView,Search,Query,GraphicsLayer,Feature) {

         const featureLayer = new FeatureLayer({
            url: url1,
            id:"1",
            outFields: ["*"]

         });
         const process_popup = {
            "title": "اشتراك",
            "content": "<b>رقم الاشتراك:</b> {SUBSCRIPTION_NO}"
         }
         const featureLayer2 = new FeatureLayer({
            url: url2,
            id:"2",
            outFields: ["*"],
            popupTemplate:process_popup

         });

         const featureLayer3 = new FeatureLayer({
            url: "https://gisserver.gedco.ps/server/rest/services/GIS_GEDCO1/North_CUSTOMERS/FeatureServer/1",
            id:"2",
            outFields: ["*"],
            popupTemplate:process_popup

         });
         const map = new Map({
            basemap: "dark-gray-vector",
            layers: [featureLayer2,featureLayer3]
         });

         const view = new MapView({
            container: "viewDiv",
            center: [31.521338, 34.443680],
            zoom: 7,
            map:map
         });

         //map.add(featureLayer);
        GeneralShowMaploading()

//لما يبحث برقم المشترك هيتحرك ف الخريطة اللي تحت ع موقع المشترك وازا ما في فيتشرز هيطلب اضافة فيتشر
         /******************
          *
          * listener on change
          *
          * **/

         view.whenLayerView(featureLayer2).then((layerView) => {

            GeneralHideMaploading();

         });

         $("#TXT_SUBSCRIBER_GIS").change(function(){
            var NewVal = $(this).val();
            console.log(NewVal);
            const query = new Query({
               outFields: ["*"],
               where: "SUBSCRIPTION_NO = "  +NewVal,
               returnGeometry:true
            });
            GeneralShowMaploading();



            featureLayer.queryFeatures(query)
               .then(function(response){
                  var feature=response.features[0];
                  if(response.features.length>0) {
                     //map.add(featureLayer);

//Highlight


                     /* view.whenLayerView(featureLayer).then((layerView) => {

                                    layerView.highlight(feature)


                                });*/
                     GeneralHideMaploading();
                     var graphicsLayer = new GraphicsLayer();

                     map.layers.add(graphicsLayer);

                     var point = {
                        type: "point",
                        longitude:feature.geometry.longitude,
                        latitude: feature.geometry.latitude
                     };

                     var simpleMarkerSymbol = {
                        type: "simple-maker",
                        color: [219, 245, 219], // orange
                        size: 40,
                        style: "circle",
                        outline: {
                           color: [219, 245, 219], // white
                           width: 5
                        }
                     };
                     let symbol = {
                        type: "simple-marker",  // autocasts as new SimpleMarkerSymbol()
                        style: "square",
                        color: "blue",
                        size: "40px",  // pixels
                        outline: {  // autocasts as new SimpleLineSymbol()
                           color: [ 255, 255, 0 ],
                           width: 3  // points
                        }
                     };
                     var pointGraphic = new Graphic({
                        geometry: point,
                        symbol: symbol
                     });
                     graphicsLayer.add(pointGraphic);


                     view.goTo(
                        {
                           target: feature.geometry,
                           tilt: 70,
                           zoom: 20
                        },
                        {
                           duration: 2000,
                           easing: "in-out-expo"
                        }
                     ).catch((error) => {
                        if (error.name != "AbortError") {
                           //console.error(error);
                        }
                     });

                  }
                  else{
                     danger_msg("خطأ","لا يوجد معلومات في GIS يرجى اضافة معلومات بالبحث عن اقرب معلم وتحديد على الخريطة");
                  }

               });

         });
         /**************
          *
          *
          * بالعنوان بحث على جوجل ماب
          *
          *
          * @type {google.maps.Geocoder}
          */

         const input = document.getElementById("pac-input");
         const searchBox = new google.maps.places.SearchBox(input);
         let markers= [];

         searchBox.addListener("places_changed", () => {
            const places = searchBox.getPlaces();

            if (places.length == 0) {
               return;
            }

            const bounds = new google.maps.LatLngBounds();

            places.forEach((place) => {
               if (!place.geometry || !place.geometry.location) {
                  console.log("Returned place contains no geometry");
                  return;
               }

               const icon = {
                  url: place.icon ,
                  size: new google.maps.Size(71, 71),
                  origin: new google.maps.Point(0, 0),
                  anchor: new google.maps.Point(17, 34),
                  scaledSize: new google.maps.Size(25, 25),
               };

               // Create a marker for each place.
               markers.push(
                  new google.maps.Marker({
                     map,
                     icon,
                     title: place.name,
                     position: place.geometry.location,
                  })
               );

               var geocoder = new google.maps.Geocoder();
               //  var address = document.getElementById('textboxid').value;

               geocoder.geocode({
                  'address': "address"
               }, function(results, status) {

                  if (status == google.maps.GeocoderStatus.OK) {
                     var latitude = results[0].geometry.location.lat();
                     var longitude = results[0].geometry.location.lng();
                  }
               });



               console.log(place);

               view.goTo(
                  {
                     target:[place.geometry.location.lng() , place.geometry.location.lat()],
                     tilt: 70,
                     zoom: 20
                  },
                  {
                     duration: 2000,
                     easing: "in-out-expo"
                  }
               ).catch((error) => {
                  if (error.name != "AbortError") {
                     //console.error(error);
                  }
               });
               point=place.geometry.location;

               MAP_WIDTH = 1379;
               MAP_HEIGHT = 1000;

               console.log( place.geometry.location.lat());
               console.log( place.geometry.location.lng());


               view.graphics.add({
                  symbol: {
                     type: "text",
                     color: "#48e331",
                     text: "\ue61d", // esri-icon-map-pin
                     font: {
                        size: 30,
                        family: "CalciteWebCoreIcons"
                     }
                  },
                  geometry: {
                     type: "point",
                     longitude:place.geometry.location.lng() ,
                     latitude: place.geometry.location.lat()
                  }
               });


            });
         });



         /******************
          *
          * listener
          *
          * **/
         let       feature;
         view.on("click", (event) => {
            var point = event.mapPoint.clone();
            point.z = undefined;
            point.hasZ = false;
            view.hitTest(event).then((response) => {

               if (response.results.length > 0&&response.results[0].graphic.attributes['OBJECTID']!=null) {
                  console.log(response.results[0].graphic.attributes['OBJECTID']);
                  /*



                                                console.log(response.results[0].graphic.attributes);
                                                feature = response.results[0].graphic;
                                                results_clicks = response.results[0].graphic.attributes;
                                                document.getElementById("editArea").style.display = "block";
                                                $('#subscriber_no').val(results_clicks["SUBSCRIPTION_NO"]);
                                                $('#OBJECTID').val(results_clicks["OBJECTID"]);
                                                $('#METER_NO').val(results_clicks["METER_NO"]);
                                                $('#CUSTOMER_NAME').val(results_clicks["CUSTOMER_NAME"]);
                                                $('#SUBSCRIPTION_TYPE').val(results_clicks["SUBSCRIPTION_TYPE"]);
                                                $('#METER_TYPE').val(results_clicks["METER_TYPE"]);
                                                $('#FEEDING_TYPE').val(results_clicks["FEEDING_TYPE"]);
                                                $('#BUILDING_NO').val(results_clicks["BUILDING_NO"]);
                                                $('#PROPERTY_DESCRIPTION').val(results_clicks["PROPERTY_DESCRIPTION"]);
                                                $('#CUSTOMER_CABLE_CODE').val(results_clicks["CUSTOMER_CABLE_CODE"]);
                                                $('#POLE_MATERLAL_ID').val(results_clicks["POLE_MATERLAL_ID"]);
                                                $('#LTL_SWITCH_CODE').val(results_clicks["LTL_SWITCH_CODE"]);
                                                $('#CUSTOMER_STATUS').val(results_clicks["CUSTOMER_STATUS"]);
                                                $('#TRANSFORMER_NAME_AR').val(results_clicks["TRANSFORMER_NAME_AR"]);
                                                $('#STREET_NAME').val(results_clicks["STREET_NAME"]);
                                                $('#DISTRICT_NUMBER').val(results_clicks["DISTRICT_NUMBER"]);
                                                $('#NOTES').val(results_clicks["NOTES"]);
                                                $('#TRANSFORMER_CODE').val(results_clicks["TRANSFORMER_CODE"]);
                                                $('#CREATED_USER').val(results_clicks["CREATED_USER"]);
                                                $('#LAST_EDITED_USER').val(results_clicks["LAST_EDITED_USER"]);
                                                $('#LAST_EDITED_DATE').val(results_clicks["LAST_EDITED_DATE"]);
                                                $('#MUNICIPALITY').val(results_clicks["MUNICIPALITY"]);
                                                $('#METER_COMPANY').val(results_clicks["METER_COMPANY"]);
                                                $('#METER_DIGITS').val(results_clicks["METER_DIGITS"]);
                                                $('#BRANCH').val(results_clicks["BRANCH"]);
                                                $('#METER_BREAK').val(results_clicks["METER_BREAK"]);
                                                $('#METER_SEALS').val(results_clicks["METER_SEALS"]);
                                                $('#BOX_SEALS').val(results_clicks["BOX_SEALS"]);
                                                $('#BREAKER').val(results_clicks["BREAKER"]);
                                                $('#SOLAR_ENERGY').val(results_clicks["SOLAR_ENERGY"]);
                                                $('#METER_READING').val(results_clicks["METER_READING"]);
                                                $('#LAST_READ').val(results_clicks["LAST_READ"]);
                                                $('#LAST_MONTH_READ_DATE').val(results_clicks["LAST_MONTH_READ_DATE"]);
                                                $('#LAST_CONSUMPTION').val(results_clicks["LAST_CONSUMPTION"]);
                                                $('#UPDATE_USER').val(results_clicks["UPDATE_USER"]);
                                                $('#UPDATE_DATE').val(results_clicks["UPDATE_DATE"]);
                                                $('#objectID').val(results_clicks["OBJECTID"]);
                        */
                  const editThisAction = {
                     title: "تعديل",
                     id: "edit-this",
                     className: "esri-icon-edit"
                  };




                  var flag = 0;
                  view.popup.on("trigger-action", (event) => {
                     if (event.action.id === "edit-this" && flag != 1) {
                        //console.log(results_clicks["OBJECTID"]);
                        updateFeature1(results_clicks["OBJECTID"], "olalfi");
                        flag = 1;

                     }
                  });


               }   else {
                  if(confirm("هل تريد اضافة مستخدم جديد في هذه النقطة؟")){


                     var   attributes=[
                        {

                           "attributes": {
                              "SUBSCRIPTION_NO": SUBSCRIBER,
                              "CUSTOMER_NAME ": "علا لافي",
                              "SUBSCRIPTION_TYPE ": "علا لافي",
                              "NOTES": "901010",
                              "STREET_NAME" : "12/2/22",
                              "DISTRICT_NUMBER": "sss",
                             "BRANCH":3,
                              "CREATED_USER":"ola",

                           }
                        }
                     ];

                     editFeature = new Graphic({
                        geometry: point,
                        attributes: attributes


                     });


                     console.log("add to process",editFeature.attributes);

                     const edits = {
                        addFeatures: [editFeature]
                     };

                     addFeatures(point);
                     //applyEditsToIncidents(edits,901010,1831,point);


                  }



               }

            });



         });


         function applyEditsToIncidents1(params,point ) {
//console.log("point",point);

            featureLayer
               .applyEdits(params)
               .then((editsResult) => {
                  // console.log("editsResult ", editsResult);

                  let objectId;
                  if (editsResult.addFeatureResults.length > 0) {
                     //console.log(editFeature.attributes);
                     const objectId = editsResult.addFeatureResults[0].objectId;
                     console.log(objectId);
                     GeneralHideMaploading();
                     update(params);

                     var   attributes=[
                        {

                           "attributes": {
                              "CUSTOMER_NAME ": "olalafiTest",
                              "CUSTOMER_STATUS": "1",
                              "SUBSCRIPTION_NO":430102046 ,
                              "UPDATE_USER ":"olafi"

                           }
                        }
                     ];


                     editFeature = new Graphic({
                        geometry: point,
                        attributes:[attributes]

                     });


                     editFeature.attributes['CUSTOMER_NAME']="olalafiTest";
                     editFeature.attributes['CUSTOMER_STATUS']="1";
                     editFeature.attributes['SUBSCRIPTION_NO']=430102046;

                     editFeature.attributes['UPDATE_USER']="olafi";
                     const edits = {
                        updateFeatures: [editFeature]
                     };
                     //applyEditsToIncidents1(edits,point );
                     /***
                      const featureLayer = new FeatureLayer({
                           url: "https://gisserver.gedco.ps/server/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
                           title: "تم العثور على",
                           outFields: ["*"]

                        });

                      featureLayer.queryFeatures(query)
                      .then(function(response){
                              response=JSON.parse(JSON.stringify(response));
                              var feature=response.features ;
                              console.log(""+ JSON.stringify(response) );
                              console.log(feature[0].attributes );

                              if(response.features.length>0) {




                              }});*/
                     featureLayer
                        .queryFeatures({
                           objectIds: [objectId],
                           outFields: ["*"],
                           returnGeometry: true
                        })
                        .then((response) => {

                           response=JSON.parse(JSON.stringify(response));
                           var feature=response.features ;
                           console.log(""+ JSON.stringify(response) );
                           feature.addFeatures

                           // console.log(feature[0].attributes );
                           /*
                                                                            var   attributes=[
                                                                                {

                                                                                    "attributes": {
                                                                                        "CUSTOMER_NAME ": "olalafiTest",
                                                                                        "CUSTOMER_STATUS": "1",
                                                                                        "SUBSCRIPTION_NO":430102046 ,
                                                                                        "UPDATE_USER ":"olafi"

                                                                                    }
                                                                                }
                                                                            ];


                                                                            var editFeature = new Graphic({
                                                                                geometry: point,
                                                                                attributes: attributes


                                                                            });
                                                                            const edits = {
                                                                                updateFeatures: [editFeature]
                                                                            };
                                                                            console.log("updateFeature",editFeature.attributes);


                                                                            console.log(edits);
                                                                            console.log("add2",editFeature);


                                                                            applyEditsToIncidents1(edits,point );*/

                        });



                     // update(objectId);


                  }else {
                     console.log(editsResult);

                     objectId = editsResult.updateFeatureResults[0].objectId;
                     ShowSuccessMessage();
                     console.log("add",p_ser_no);
                     // get_to_link('/'+_base_name+'/EditIssues/'+p_ser_no);
                     //  get_to_link('/'+_base_name+'/EditIssues/'+element['o_msgtxt']);
                  }




               })
               .catch((error) => {
                  console.log("error = ", error);
                  GeneralHideMaploading();

               });
         }
         function applyEditsToLayer(edits) {
            featureLayer2
               .applyEdits(edits)
               .then((results) => {
                  // if edits were removed
                  if (results.deleteFeatureResults.length > 0){
                     console.log(
                        results.deleteFeatureResults.length,
                        "features have been removed"
                     );
                  }
                  // if features were added - call queryFeatures to return
                  //    newly added graphics
                  if (results.addFeatureResults.length > 0){
                     var objectIds = [];
                     results.addFeatureResults.forEach((item) => {

                        objectIds.push(item.objectId);
                        console.log(item.objectId);
                     });
                     // query the newly added features from the layer
                     featureLayer2
                        .queryFeatures({
                           objectIds: objectIds
                        })
                        .then((results) => {
                           console.log(
                              results ,
                              "features have been added."
                           );
                           console.log(
                              results.features.length,
                              "features have been added."
                           );

                           if(results.features.length>0){
                              setTimeout(ShowSuccessMessage,40000);
                              window.close();


                           }

                        })
                  }
               })
               .catch((error) => {
                  console.error();
               });
         }
         function applyEditsToIncidents(params,p_ser_no,username,point) {
            featureLayer2
               .applyEdits(params)
               .then((editsResult) => {

                  if (editsResult.addFeatureResults.length > 0 || editsResult.updateFeatureResults.length > 0) {
                     let objectId;
                     if (editsResult.addFeatureResults.length > 0) {
                        //console.log(editFeature.attributes);
                        console.log(editsResult);
                        objectId = editsResult.addFeatureResults[0].objectId;
                        featureLayer2
                           .queryFeatures({
                              objectIds: [objectId],
                              outFields: ["*"],
                              returnGeometry: true
                           })
                           .then((results) => {



                              console.log("ola",results);


                              var TXT_P_DATE = $('#TXT_P_DATE').val();

                              var TXT_SER_BOCK_NO = $('#TXT_SER_BOCK_NO').val();
                              var TXT_NAME = $('#TXT_NAME').val();
                              var TXT_ADD_ = $('#TXT_ADD_').val();
                              var TXT_FEEDER_TRANS = $('#DL_FEEDER_TRANS').val();
                              var TXT_FEEDER_KNIFE = $('#DL_FEEDER_KNIFE').val();
                              var TXT_TO_LOC = $('#TXT_LOC').val();
                              var TXT_SUBSCRIBER_TYPE = $('#TXT_SUBSCRIBER_TYPE').val();
                              var TXT_BRANCH = $('#TXT_REQUEST_BRANCH_ID').val();
                              var TXT_BOARD_CAPACITY = $('#TXT_BOARD_CAPACITY').val();
                              var BOARD_TYPE = $('#DL_BOARD_TYPE').val() ;
                              var TXT_ID_P = $('#TXT_ID_P').val() ;
                              var CABLE_TYPE =  $('#DL_CABLE_TYPE').val();
                              var CABLE_WIDTH =   $('#TXT_CABLE_WIDTH').val();
                              var CABLE_POSITION =  $('#DL_CABLE_POSITION').val();
                              var FLAT_NO = $('#TXT_FLAT_NO').val();
                              var B_NAME = $('#TXT_B_NAME').val();
                              var   attributes=[
                                 {

                                    "attributes": {
                                       "SUBSCRIPTION_NO": SUBSCRIBER

                                    },"geometry":point
                                 }
                              ];

                              results.features[0].attributes=attributes;


                              /*
                                                                                results.features.attributes=SUBSCRIBER;
                                                                                results.features.attributes['CUSTOMER_NAME']="ola";
                                                                                results.features.attributes['SUBSCRIPTION_TYPE']="1";
                                                                                results.features.attributes['NOTES']="901010";
                                                                                results.features.attributes['STREET_NAME']="901010";
                                                                                results.features.attributes['DISTRICT_NUMBER']="901010";
                                                                               results.features.attributes['BRANCH']="3";
                                                                                results.features.attributes['CREATED_USER']="olafi";*/

                              // results.features[0].attributes['P_DATE']=TXT_P_DATE;
                              /**    results.features[0].attributes['ADD_']=TXT_ADD_;
                               results.features[0].attributes['ENTRY_USER']=username;

                               //رقم هوية المشترك
                               results.features[0].attributes['ID_P']=TXT_ID_P;
                               //سعة اللوحة
                               results.features[0].attributes['BOARD_CAPACITY']=parseFloat(TXT_BOARD_CAPACITY);
                               //نوع اللوحة
                               //////////////////////////////////          results.features[0].attributes['BOARD_TYPE']=BOARD_TYPE;
                               results.features[0].attributes['NAME']=$('#TXT_NAME').val();
                               //العنوان
                               results.features[0].attributes['ADD_']=TXT_ADD_;
                               //المحول المغذي
                               results.features[0].attributes['FEEDER_TRANS']=TXT_FEEDER_TRANS;
                               //الموقع
                               results.features[0].attributes['LOC']=TXT_TO_LOC;
                               //نوع الاشتراك
                               results.features[0].attributes['SUBSCRIBER_TYPE']=TXT_SUBSCRIBER_TYPE ;
                               //حالة القضية
                               results.features[0].attributes['V_PROCESS_CASE']=1;
                               //رقم المحضر
                               results.features[0].attributes['SER_BOCK_NO']=parseFloat(TXT_SER_BOCK_NO) ;
                               //سكينة التغذية
                               results.features[0].attributes['FEEDER_KNIFE']=parseFloat(TXT_FEEDER_KNIFE) ;
                               //المقر
                               results.features[0].attributes['BRANCH_ID']=parseFloat(TXT_BRANCH) ;
                               //نوع الكابل
                               results.features[0].attributes['CABLE_TYPE']=parseFloat(CABLE_TYPE) ;
                               //سمك الكابل
                               results.features[0].attributes['CABLE_WIDTH']=CABLE_WIDTH;
                               //موقع الكابل
                               results.features[0].attributes['CABLE_POSITION']=parseFloat(CABLE_POSITION) ;
                               //عدد الشقق
                               results.features[0].attributes['FLAT_NO']=parseFloat(FLAT_NO);


                               */

                              editFeature = new Graphic({
                                 geometry: point,
                                 attributes:results.features.attributes

                              });

                              let    feature = new Feature({
                                 graphic: editFeature,
                                 map: map});

                              console.log("new Att",editFeature.attributes);

                              const edits = {
                                 updateFeatures: [editFeature]
                              };

                              console.log(editFeature.attributes);





                              applyEditsToIncidents(edits,p_ser_no,username,SUBSCRIBER);




                           });


                    } else {
                        console.log(editsResult);

                        objectId = editsResult.updateFeatureResults[0].objectId;
                        ShowSuccessMessage();
                        console.log("updated",p_ser_no);
                        setTimeout(function(){
                           window.close();
                        }  ,4000);
                     }
                     console.log(objectId);
                  }

               })
               .catch((error) => {
                  console.log("error = ", error);
               });
         }
         function addFeatures(point){
            // data to be added to the map
            const data = [
               {
                  SUBSCRIPTION_NO: "30101010",
                  BRANCH: 3
               }
            ];

            // create an array of graphics based on the data above
            var graphics = [];
            var graphic;
               graphic = new Graphic({
                  geometry: point,
                  attributes: data[0]
               });
               graphics.push(graphic);


            // addEdits object tells applyEdits that you want to add the features
            const addEdits = {
               addFeatures: graphics
            };

            // apply the edits to the layer
            applyEditsToLayer(addEdits);
         }

         function update(params){
            const featureLayer = new FeatureLayer({
               url: "https://gisserver.gedco.ps/server/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
               title: "تم العثور على",
               outFields: ["*"]

            });
            featureLayer
               .queryFeatures({
                  objectIds: [209922],
                  outFields: ["*"],
                  returnGeometry: true
               })
               .then((results) => {
                  console.log(""+results.features);

                  /**     results.features[0].attributes['CUSTOMER_NAME']="olalafiTest";
                   results.features[0].attributes['CUSTOMER_STATUS']="1";
                   results.features[0].attributes['UPDATE_USER']="olafi";
                   results.features[0].attributes['SUBSCRIPTION_NO']="430102046";





                   editFeature = new Graphic({
                                 geometry: point,
                                 attributes:results.features.attributes

                              });

                   console.log("new Att",editFeature.attributes);

                   const edits = {
                                 updateFeatures: [editFeature]
                              };

                   console.log(editFeature.attributes);





                   applyEditsToIncidents1(edits);

                   */


               });






         }
      });






}
function addsubscriberMapWithGoogle( SUBSCRIBER,url1,url2){


   require([
         "esri/rest/find",
         "esri/rest/support/FindParameters",
         "esri/widgets/FeatureTable",
         "esri/layers/FeatureLayer",
         "esri/portal/Portal",
         "esri/identity/OAuthInfo",
         "esri/identity/IdentityManager",
         "esri/Graphic",
         "esri/Map",
         "esri/views/MapView",
         "esri/widgets/Search",
         "esri/rest/support/Query",
         "esri/layers/GraphicsLayer"

      ],
      function (find, FindParameters,FeatureTable,FeatureLayer,Portal, OAuthInfo, esriId,Graphic,Map,MapView,Search,Query,GraphicsLayer) {

         const featureLayer = new FeatureLayer({
            url: url1,
            id:"1",
            outFields: ["*"]

         });
         const process_popup = {
            "title": "قضية",
            "content": "<b>رقم القضية:</b> {P_SER_NO}<br><b>رقم الاشتراك:</b> {SUBSCRIBER}<br><b>حالة القضية:</b> {v_process_case}<br><b>اخر تعديل:</b> {UPDATED__USER_N}<br><b>تاريخ المحضر:</b> {CREATE_DATE_N} "
         }
         const featureLayer2 = new FeatureLayer({
            url: url2,
            id:"2",
            outFields: ["*"],
            popupTemplate:process_popup

         });

         const featureLayer3 = new FeatureLayer({
            url: "https://gisserver.gedco.ps/server/rest/services/GIS_GEDCO1/North_CUSTOMERS/FeatureServer/1",
            id:"2",
            outFields: ["*"],
            popupTemplate:process_popup

         });
         const map = new Map({
            basemap: "dark-gray-vector",
            layers: [featureLayer2,featureLayer3]
         });

         const view = new MapView({
            container: "viewDiv",
            center: [31.521338, 34.443680],
            zoom: 7,
            map:map
         });
         view.goTo({
            target:[31.521721, 34.443999]
         });
         //map.add(featureLayer);
         GeneralShowMaploading()

//لما يبحث برقم المشترك هيتحرك ف الخريطة اللي تحت ع موقع المشترك وازا ما في فيتشرز هيطلب اضافة فيتشر
         /******************
          *
          * listener on change
          *
          * **/

        view.whenLayerView(featureLayer2).then((layerView) => {

            GeneralHideMaploading();

         });

         $("#TXT_SUBSCRIBER_GIS").change(function(){
            var NewVal = $(this).val();
            console.log(NewVal);
            const query = new Query({
               outFields: ["*"],
               where: "SUBSCRIPTION_NO = "  +NewVal,
               returnGeometry:true
            });
            GeneralShowMaploading();



            featureLayer.queryFeatures(query)
               .then(function(response){
                  var feature=response.features[0];
                  if(response.features.length>0) {
                     //map.add(featureLayer);

//Highlight


                     /* view.whenLayerView(featureLayer).then((layerView) => {

                                    layerView.highlight(feature)


                                });*/
                     GeneralHideMaploading();
                     var graphicsLayer = new GraphicsLayer();

                     map.layers.add(graphicsLayer);

                     var point = {
                        type: "point",
                        longitude:feature.geometry.longitude,
                        latitude: feature.geometry.latitude
                     };

                     var simpleMarkerSymbol = {
                        type: "simple-maker",
                        color: [219, 245, 219], // orange
                        size: 40,
                        style: "circle",
                        outline: {
                           color: [219, 245, 219], // white
                           width: 5
                        }
                     };
                     let symbol = {
                        type: "simple-marker",  // autocasts as new SimpleMarkerSymbol()
                        style: "square",
                        color: "blue",
                        size: "40px",  // pixels
                        outline: {  // autocasts as new SimpleLineSymbol()
                           color: [ 255, 255, 0 ],
                           width: 3  // points
                        }
                     };
                     var pointGraphic = new Graphic({
                        geometry: point,
                        symbol: symbol
                     });
                     graphicsLayer.add(pointGraphic);


                     view.goTo(
                        {
                           target: feature.geometry,
                           tilt: 70,
                           zoom: 20
                        },
                        {
                           duration: 2000,
                           easing: "in-out-expo"
                        }
                     ).catch((error) => {
                        if (error.name != "AbortError") {
                           //console.error(error);
                        }
                     });

                  }
                  else{
                     danger_msg("خطأ","لا يوجد معلومات في GIS يرجى اضافة معلومات بالبحث عن اقرب معلم وتحديد على الخريطة");
                  }

               });

         });



         /******************
          *
          * listener
          *
          * **/
         let       feature;
         view.on("click", (event) => {
            var point = event.mapPoint.clone();
            point.z = undefined;
            point.hasZ = false;
            view.hitTest(event).then((response) => {

               if (response.results.length > 0&&response.results[0].graphic.attributes['OBJECTID']!=null) {
                  console.log(response.results[0].graphic.attributes['OBJECTID']);
                  /*



                                                console.log(response.results[0].graphic.attributes);
                                                feature = response.results[0].graphic;
                                                results_clicks = response.results[0].graphic.attributes;
                                                document.getElementById("editArea").style.display = "block";
                                                $('#subscriber_no').val(results_clicks["SUBSCRIPTION_NO"]);
                                                $('#OBJECTID').val(results_clicks["OBJECTID"]);
                                                $('#METER_NO').val(results_clicks["METER_NO"]);
                                                $('#CUSTOMER_NAME').val(results_clicks["CUSTOMER_NAME"]);
                                                $('#SUBSCRIPTION_TYPE').val(results_clicks["SUBSCRIPTION_TYPE"]);
                                                $('#METER_TYPE').val(results_clicks["METER_TYPE"]);
                                                $('#FEEDING_TYPE').val(results_clicks["FEEDING_TYPE"]);
                                                $('#BUILDING_NO').val(results_clicks["BUILDING_NO"]);
                                                $('#PROPERTY_DESCRIPTION').val(results_clicks["PROPERTY_DESCRIPTION"]);
                                                $('#CUSTOMER_CABLE_CODE').val(results_clicks["CUSTOMER_CABLE_CODE"]);
                                                $('#POLE_MATERLAL_ID').val(results_clicks["POLE_MATERLAL_ID"]);
                                                $('#LTL_SWITCH_CODE').val(results_clicks["LTL_SWITCH_CODE"]);
                                                $('#CUSTOMER_STATUS').val(results_clicks["CUSTOMER_STATUS"]);
                                                $('#TRANSFORMER_NAME_AR').val(results_clicks["TRANSFORMER_NAME_AR"]);
                                                $('#STREET_NAME').val(results_clicks["STREET_NAME"]);
                                                $('#DISTRICT_NUMBER').val(results_clicks["DISTRICT_NUMBER"]);
                                                $('#NOTES').val(results_clicks["NOTES"]);
                                                $('#TRANSFORMER_CODE').val(results_clicks["TRANSFORMER_CODE"]);
                                                $('#CREATED_USER').val(results_clicks["CREATED_USER"]);
                                                $('#LAST_EDITED_USER').val(results_clicks["LAST_EDITED_USER"]);
                                                $('#LAST_EDITED_DATE').val(results_clicks["LAST_EDITED_DATE"]);
                                                $('#MUNICIPALITY').val(results_clicks["MUNICIPALITY"]);
                                                $('#METER_COMPANY').val(results_clicks["METER_COMPANY"]);
                                                $('#METER_DIGITS').val(results_clicks["METER_DIGITS"]);
                                                $('#BRANCH').val(results_clicks["BRANCH"]);
                                                $('#METER_BREAK').val(results_clicks["METER_BREAK"]);
                                                $('#METER_SEALS').val(results_clicks["METER_SEALS"]);
                                                $('#BOX_SEALS').val(results_clicks["BOX_SEALS"]);
                                                $('#BREAKER').val(results_clicks["BREAKER"]);
                                                $('#SOLAR_ENERGY').val(results_clicks["SOLAR_ENERGY"]);
                                                $('#METER_READING').val(results_clicks["METER_READING"]);
                                                $('#LAST_READ').val(results_clicks["LAST_READ"]);
                                                $('#LAST_MONTH_READ_DATE').val(results_clicks["LAST_MONTH_READ_DATE"]);
                                                $('#LAST_CONSUMPTION').val(results_clicks["LAST_CONSUMPTION"]);
                                                $('#UPDATE_USER').val(results_clicks["UPDATE_USER"]);
                                                $('#UPDATE_DATE').val(results_clicks["UPDATE_DATE"]);
                                                $('#objectID').val(results_clicks["OBJECTID"]);
                        */
                  const editThisAction = {
                     title: "تعديل",
                     id: "edit-this",
                     className: "esri-icon-edit"
                  };




                  var flag = 0;
                  view.popup.on("trigger-action", (event) => {
                     if (event.action.id === "edit-this" && flag != 1) {
                        //console.log(results_clicks["OBJECTID"]);
                        updateFeature1(results_clicks["OBJECTID"], "olalfi");
                        flag = 1;

                     }
                  });


               }   else {
                  if(confirm("هل تريد اضافة مستخدم جديد في هذه النقطة؟")){


                     var   attributes=[
                        {

                           "attributes": {
                              "SUBSCRIPTION_NO": SUBSCRIBER,
                              "CUSTOMER_NAME ": "علا لافي",
                              "SUBSCRIPTION_TYPE ": "علا لافي",
                              "NOTES": "901010",
                              "STREET_NAME" : "12/2/22",
                              "DISTRICT_NUMBER": "sss",
                              "BRANCH":"ola",
                              "CREATED_USER":"ola",

                           }
                        }
                     ];

                     editFeature = new Graphic({
                        geometry: point,
                        attributes: attributes


                     });


                     console.log("add to process",editFeature.attributes);

                     const edits = {
                        addFeatures: [editFeature]
                     };


                     applyEditsToIncidents(edits,901010,1831,point);


                  }



               }

            });



         });


         function applyEditsToIncidents1(params,point ) {
//console.log("point",point);

            featureLayer
               .applyEdits(params)
               .then((editsResult) => {
                  // console.log("editsResult ", editsResult);

                  let objectId;
                  if (editsResult.addFeatureResults.length > 0) {
                     //console.log(editFeature.attributes);
                     const objectId = editsResult.addFeatureResults[0].objectId;
                     console.log(objectId);
                     GeneralHideMaploading();
                     update(params);

                     var   attributes=[
                        {

                           "attributes": {
                              "CUSTOMER_NAME ": "olalafiTest",
                              "CUSTOMER_STATUS": "1",
                              "SUBSCRIPTION_NO":430102046 ,
                              "UPDATE_USER ":"olafi"

                           }
                        }
                     ];


                     editFeature = new Graphic({
                        geometry: point,
                        attributes:[attributes]

                     });


                     editFeature.attributes['CUSTOMER_NAME']="olalafiTest";
                     editFeature.attributes['CUSTOMER_STATUS']="1";
                     editFeature.attributes['SUBSCRIPTION_NO']=430102046;

                     editFeature.attributes['UPDATE_USER']="olafi";
                     const edits = {
                        updateFeatures: [editFeature]
                     };
                     //applyEditsToIncidents1(edits,point );
                     /***
                      const featureLayer = new FeatureLayer({
                           url: "https://gisserver.gedco.ps/server/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
                           title: "تم العثور على",
                           outFields: ["*"]

                        });

                      featureLayer.queryFeatures(query)
                      .then(function(response){
                              response=JSON.parse(JSON.stringify(response));
                              var feature=response.features ;
                              console.log(""+ JSON.stringify(response) );
                              console.log(feature[0].attributes );

                              if(response.features.length>0) {




                              }});*/
                     featureLayer
                        .queryFeatures({
                           objectIds: [objectId],
                           outFields: ["*"],
                           returnGeometry: true
                        })
                        .then((response) => {

                           response=JSON.parse(JSON.stringify(response));
                           var feature=response.features ;
                           console.log(""+ JSON.stringify(response) );
                           feature.addFeatures

                           // console.log(feature[0].attributes );
                           /*
                                                                            var   attributes=[
                                                                                {

                                                                                    "attributes": {
                                                                                        "CUSTOMER_NAME ": "olalafiTest",
                                                                                        "CUSTOMER_STATUS": "1",
                                                                                        "SUBSCRIPTION_NO":430102046 ,
                                                                                        "UPDATE_USER ":"olafi"

                                                                                    }
                                                                                }
                                                                            ];


                                                                            var editFeature = new Graphic({
                                                                                geometry: point,
                                                                                attributes: attributes


                                                                            });
                                                                            const edits = {
                                                                                updateFeatures: [editFeature]
                                                                            };
                                                                            console.log("updateFeature",editFeature.attributes);


                                                                            console.log(edits);
                                                                            console.log("add2",editFeature);


                                                                            applyEditsToIncidents1(edits,point );*/

                        });



                     // update(objectId);


                  }else {
                     console.log(editsResult);

                     objectId = editsResult.updateFeatureResults[0].objectId;
                     ShowSuccessMessage();
                     console.log("add",p_ser_no);
                     // get_to_link('/'+_base_name+'/EditIssues/'+p_ser_no);
                     //  get_to_link('/'+_base_name+'/EditIssues/'+element['o_msgtxt']);
                  }




               })
               .catch((error) => {
                  console.log("error = ", error);
                  GeneralHideMaploading();

               });
         }
         function applyEditsToIncidents(params,p_ser_no,username,point) {
            featureLayer2
               .applyEdits(params)
               .then((editsResult) => {

                  if (editsResult.addFeatureResults.length > 0 || editsResult.updateFeatureResults.length > 0) {
                     let objectId;
                     if (editsResult.addFeatureResults.length > 0) {
                        //console.log(editFeature.attributes);
                        console.log(editsResult);
                        objectId = editsResult.addFeatureResults[0].objectId;
                        featureLayer2
                           .queryFeatures({
                              objectIds: [objectId],
                              outFields: ["*"],
                              returnGeometry: true
                           })
                           .then((results) => {



                              console.log("ola",results);


                              var TXT_P_DATE = $('#TXT_P_DATE').val();

                              var TXT_SER_BOCK_NO = $('#TXT_SER_BOCK_NO').val();
                              var TXT_NAME = $('#TXT_NAME').val();
                              var TXT_ADD_ = $('#TXT_ADD_').val();
                              var TXT_FEEDER_TRANS = $('#DL_FEEDER_TRANS').val();
                              var TXT_FEEDER_KNIFE = $('#DL_FEEDER_KNIFE').val();
                              var TXT_TO_LOC = $('#TXT_LOC').val();
                              var TXT_SUBSCRIBER_TYPE = $('#TXT_SUBSCRIBER_TYPE').val();
                              var TXT_BRANCH = $('#TXT_REQUEST_BRANCH_ID').val();
                              var TXT_BOARD_CAPACITY = $('#TXT_BOARD_CAPACITY').val();
                              var BOARD_TYPE = $('#DL_BOARD_TYPE').val() ;
                              var TXT_ID_P = $('#TXT_ID_P').val() ;
                              var CABLE_TYPE =  $('#DL_CABLE_TYPE').val();
                              var CABLE_WIDTH =   $('#TXT_CABLE_WIDTH').val();
                              var CABLE_POSITION =  $('#DL_CABLE_POSITION').val();
                              var FLAT_NO = $('#TXT_FLAT_NO').val();
                              var B_NAME = $('#TXT_B_NAME').val();
                              var   attributes=[
                                 {

                                    "attributes": {
                                       "SUBSCRIPTION_NO": SUBSCRIBER

                                    },"geometry":point
                                 }
                              ];

                              results.features=attributes;

                              /*
                                                                                results.features.attributes=SUBSCRIBER;
                                                                                results.features.attributes['CUSTOMER_NAME']="ola";
                                                                                results.features.attributes['SUBSCRIPTION_TYPE']="1";
                                                                                results.features.attributes['NOTES']="901010";
                                                                                results.features.attributes['STREET_NAME']="901010";
                                                                                results.features.attributes['DISTRICT_NUMBER']="901010";
                                                                                results.features.attributes['BRANCH']="3";
                                                                                results.features.attributes['CREATED_USER']="olafi";*/

                              // results.features[0].attributes['P_DATE']=TXT_P_DATE;
                              /**    results.features[0].attributes['ADD_']=TXT_ADD_;
                               results.features[0].attributes['ENTRY_USER']=username;

                               //رقم هوية المشترك
                               results.features[0].attributes['ID_P']=TXT_ID_P;
                               //سعة اللوحة
                               results.features[0].attributes['BOARD_CAPACITY']=parseFloat(TXT_BOARD_CAPACITY);
                               //نوع اللوحة
                               //////////////////////////////////          results.features[0].attributes['BOARD_TYPE']=BOARD_TYPE;
                               results.features[0].attributes['NAME']=$('#TXT_NAME').val();
                               //العنوان
                               results.features[0].attributes['ADD_']=TXT_ADD_;
                               //المحول المغذي
                               results.features[0].attributes['FEEDER_TRANS']=TXT_FEEDER_TRANS;
                               //الموقع
                               results.features[0].attributes['LOC']=TXT_TO_LOC;
                               //نوع الاشتراك
                               results.features[0].attributes['SUBSCRIBER_TYPE']=TXT_SUBSCRIBER_TYPE ;
                               //حالة القضية
                               results.features[0].attributes['V_PROCESS_CASE']=1;
                               //رقم المحضر
                               results.features[0].attributes['SER_BOCK_NO']=parseFloat(TXT_SER_BOCK_NO) ;
                               //سكينة التغذية
                               results.features[0].attributes['FEEDER_KNIFE']=parseFloat(TXT_FEEDER_KNIFE) ;
                               //المقر
                               results.features[0].attributes['BRANCH_ID']=parseFloat(TXT_BRANCH) ;
                               //نوع الكابل
                               results.features[0].attributes['CABLE_TYPE']=parseFloat(CABLE_TYPE) ;
                               //سمك الكابل
                               results.features[0].attributes['CABLE_WIDTH']=CABLE_WIDTH;
                               //موقع الكابل
                               results.features[0].attributes['CABLE_POSITION']=parseFloat(CABLE_POSITION) ;
                               //عدد الشقق
                               results.features[0].attributes['FLAT_NO']=parseFloat(FLAT_NO);


                               */

                              editFeature = new Graphic({
                                 geometry: point,
                                 attributes:results.features.attributes

                              });

                              console.log("new Att",editFeature.attributes);

                              const edits = {
                                 updateFeatures: [editFeature]
                              };

                              console.log(editFeature.attributes);





                              applyEditsToIncidents(edits,p_ser_no,username,SUBSCRIBER);




                           });


                     } else {
                        console.log(editsResult);

                        objectId = editsResult.updateFeatureResults[0].objectId;
                        ShowSuccessMessage();
                        console.log("updated",p_ser_no);
                        setTimeout(function(){
                           window.close();
                        }  ,4000);
                     }
                     console.log(objectId);
                  }

               })
               .catch((error) => {
                  console.log("error = ", error);
               });
         }

         function update(params){
            const featureLayer = new FeatureLayer({
               url: "https://gisserver.gedco.ps/server/rest/services/GIS_GEDCO1/LV_North/FeatureServer/1",
               title: "تم العثور على",
               outFields: ["*"]

            });
            featureLayer
               .queryFeatures({
                  objectIds: [209922],
                  outFields: ["*"],
                  returnGeometry: true
               })
               .then((results) => {
                  console.log(""+results.features);

                  /**     results.features[0].attributes['CUSTOMER_NAME']="olalafiTest";
                   results.features[0].attributes['CUSTOMER_STATUS']="1";
                   results.features[0].attributes['UPDATE_USER']="olafi";
                   results.features[0].attributes['SUBSCRIPTION_NO']="430102046";





                   editFeature = new Graphic({
                                 geometry: point,
                                 attributes:results.features.attributes

                              });

                   console.log("new Att",editFeature.attributes);

                   const edits = {
                                 updateFeatures: [editFeature]
                              };

                   console.log(editFeature.attributes);





                   applyEditsToIncidents1(edits);

                   */


               });






         }
      });






}