<?php
require('UploadHandler.php');

/*
 *  custom class for uploading files, simply extends the UploadHander class
 */
class CustomUploadHandler extends UploadHandler {


    /*
     * rewreite the handle_file_upload() function to use FTP to send the files to the FTP server
     */
    protected function handle_file_upload($uploaded_file, $name, $size, $type, $error, $index = null, $content_range = null) {
        $file = new stdClass();
        $file->name = $this->get_file_name($uploaded_file, $name, $size, $type, $error,$index, $content_range);
        $file->size = $this->fix_integer_overflow((int)$size);
        $file->type = $type;
        if ($this->validate($uploaded_file, $file, $error, $index)) {
            $this->handle_form_data($file, $index);
            $upload_dir = $this->get_upload_path();
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, $this->options['mkdir_mode'], true);
            }
            $file_path = $this->get_upload_path($file->name);
            $append_file = $content_range && is_file($file_path) &&
                $file->size > $this->get_file_size($file_path);
            if ($uploaded_file && is_uploaded_file($uploaded_file)) {
                // multipart/formdata uploads (POST method uploads)
                if ($append_file) {
                    file_put_contents(
                        $file_path,
                        fopen($uploaded_file, 'r'),
                        FILE_APPEND
                    );
                } else {
                    move_uploaded_file($uploaded_file, $file_path);
                }
            } else {
                // Non-multipart uploads (PUT method support)
                file_put_contents(
                    $file_path,
                    fopen('php://input', 'r'),
                    $append_file ? FILE_APPEND : 0
                );
            }
            $file_size = $this->get_file_size($file_path, $append_file);
            if ($file_size === $file->size) {
                $file->url = $this->get_download_url($file->name);
                if ($this->is_valid_image_file($file_path)) {
                    $this->handle_image_file($file_path, $file);
                }
            } else {
                $file->size = $file_size;
                if (!$content_range && $this->options['discard_aborted_uploads']) {
                    unlink($file_path);
                    $file->error = $this->get_error_message('abort');
                }
            }
            $this->set_additional_file_properties($file);
        }
		/* 
         * now send it to the FTPserver
         */
        $source_file = $file_path; // the path of the file to upload
        $destination_file = '/your/path/' . $file->name; // the file path to upload to (must have trailing / in the path before the $file->name is appended)

        $ftp_error = $this->ftp_upload($source_file, $destination_file);

        if ($ftp_error != '') {
          $file->error = $ftp_error;
        }

        return $file;
	}
	/*
     * new function for uploading using FTP
     */
    protected function ftp_upload($source_file, $destination_file) {

        $ftp_server = '192.168.0.16';
        $ftp_user_name = 'arch';
        $ftp_user_pass = 'gsgfc';
        $port_number = 'YOUR FTP PORT NUMBER';

        $error = '';

        // set up basic connection
        $conn_id = ftp_connect($ftp_server, $port_number); 
        if (!$conn_id) {
            $error = "FTP connection has failed! Connection attempt was blocked." ;
            return $error;
        }

        // login with username and password
        $login_result = ftp_login($conn_id, $ftp_user_name, $ftp_user_pass); 

        // check connection
        if (!$login_result) { 
            $error = "FTP connection has failed! ";
            $error .= "Could not log into fpt://$ftp_server for user $ftp_user_name"; 
            return $error;
        }

        // upload the file
        $upload = ftp_put($conn_id, $destination_file, $source_file, FTP_BINARY); 

        // check upload status
        if (!$upload) { 
            $error = "FTP upload has failed!";
        } else {
            $error =  "Uploaded $source_file to $ftp_server as $destination_file";
        }

        // close the FTP stream 
        ftp_close($conn_id); 

        return $error;
    }
}
?>